/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;

@SdkInternalApi
final class DynamoDbRetryPolicy {
    private static final int LEGACY_MAX_ERROR_RETRY = 8;
    private static final Duration LEGACY_BASE_DELAY = Duration.ofMillis(25L);
    private static final BackoffStrategy LEGACY_BACKOFF_STRATEGY = FullJitterBackoffStrategy.builder().baseDelay(LEGACY_BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();
    private static final RetryPolicy LEGACY_RETRY_POLICY = AwsRetryPolicy.defaultRetryPolicy().toBuilder().numRetries(Integer.valueOf(8)).backoffStrategy(LEGACY_BACKOFF_STRATEGY).additionalRetryConditionsAllowed(false).build();

    private DynamoDbRetryPolicy() {
    }

    public static RetryPolicy defaultRetryPolicy() {
        if (RetryMode.defaultRetryMode() == RetryMode.LEGACY) {
            return LEGACY_RETRY_POLICY;
        }
        return AwsRetryPolicy.defaultRetryPolicy().toBuilder().additionalRetryConditionsAllowed(false).build();
    }

    public static RetryPolicy addRetryConditions(RetryPolicy policy) {
        return policy;
    }
}

