/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchGetItemRequestModelMarshaller {
    private static final MarshallingInfo<Map> REQUESTITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestItems").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").isBinary(false).build();
    private static final BatchGetItemRequestModelMarshaller INSTANCE = new BatchGetItemRequestModelMarshaller();

    private BatchGetItemRequestModelMarshaller() {
    }

    public static BatchGetItemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetItemRequest batchGetItemRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchGetItemRequest), (String)"batchGetItemRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchGetItemRequest.requestItems(), REQUESTITEMS_BINDING);
            protocolMarshaller.marshall((Object)batchGetItemRequest.returnConsumedCapacityAsString(), RETURNCONSUMEDCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

