/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LocalSecondaryIndexInfoMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROJECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Projection").isBinary(false).build();
    private static final LocalSecondaryIndexInfoMarshaller INSTANCE = new LocalSecondaryIndexInfoMarshaller();

    private LocalSecondaryIndexInfoMarshaller() {
    }

    public static LocalSecondaryIndexInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LocalSecondaryIndexInfo localSecondaryIndexInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)localSecondaryIndexInfo, (String)"localSecondaryIndexInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)localSecondaryIndexInfo.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(localSecondaryIndexInfo.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)localSecondaryIndexInfo.projection(), PROJECTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

