/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class QueryIterable
implements SdkIterable<QueryResponse> {
    private final DynamoDBClient client;
    private final QueryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public QueryIterable(DynamoDBClient client, QueryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new QueryResponseFetcher();
    }

    public Iterator<QueryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Map<String, AttributeValue>> items() {
        Function<QueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final QueryIterable resume(QueryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new QueryIterable(this.client, (QueryRequest)((Object)this.firstRequest.toBuilder().exclusiveStartKey(lastSuccessfulPage.lastEvaluatedKey()).build()));
        }
        return new QueryIterable(this.client, this.firstRequest){

            @Override
            public Iterator<QueryResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class QueryResponseFetcher
    implements SyncPageFetcher<QueryResponse> {
        private QueryResponseFetcher() {
        }

        public boolean hasNextPage(QueryResponse previousPage) {
            return previousPage.lastEvaluatedKey() != null;
        }

        public QueryResponse nextPage(QueryResponse previousPage) {
            if (previousPage == null) {
                return QueryIterable.this.client.query(QueryIterable.this.firstRequest);
            }
            return QueryIterable.this.client.query((QueryRequest)((Object)QueryIterable.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

