/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.transform.IdentityUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.StreamRecordUnmarshaller;

public class RecordUnmarshaller
implements Unmarshaller<Record, JsonUnmarshallerContext> {
    private static final RecordUnmarshaller INSTANCE = new RecordUnmarshaller();

    public Record unmarshall(JsonUnmarshallerContext context) throws Exception {
        Record.Builder recordBuilder = Record.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("eventID", targetDepth)) {
                    context.nextToken();
                    recordBuilder.eventID((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eventName", targetDepth)) {
                    context.nextToken();
                    recordBuilder.eventName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eventVersion", targetDepth)) {
                    context.nextToken();
                    recordBuilder.eventVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eventSource", targetDepth)) {
                    context.nextToken();
                    recordBuilder.eventSource((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsRegion", targetDepth)) {
                    context.nextToken();
                    recordBuilder.awsRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("dynamodb", targetDepth)) {
                    context.nextToken();
                    recordBuilder.dynamodb(StreamRecordUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("userIdentity", targetDepth)) {
                    context.nextToken();
                    recordBuilder.userIdentity(IdentityUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Record)recordBuilder.build();
    }

    public static RecordUnmarshaller getInstance() {
        return INSTANCE;
    }
}

