/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;

@SdkInternalApi
public class ItemCollectionMetricsMarshaller {
    private static final MarshallingInfo<Map> ITEMCOLLECTIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCollectionKey").build();
    private static final MarshallingInfo<List> SIZEESTIMATERANGEGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeEstimateRangeGB").build();
    private static final ItemCollectionMetricsMarshaller INSTANCE = new ItemCollectionMetricsMarshaller();

    public static ItemCollectionMetricsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ItemCollectionMetrics itemCollectionMetrics, ProtocolMarshaller protocolMarshaller) {
        if (itemCollectionMetrics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(itemCollectionMetrics.itemCollectionKey(), ITEMCOLLECTIONKEY_BINDING);
            protocolMarshaller.marshall(itemCollectionMetrics.sizeEstimateRangeGB(), SIZEESTIMATERANGEGB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

