/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTablesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListTablesRequest> {
    private final String exclusiveStartTableName;
    private final Integer limit;

    private ListTablesRequest(BuilderImpl builder) {
        this.exclusiveStartTableName = builder.exclusiveStartTableName;
        this.limit = builder.limit;
    }

    public String exclusiveStartTableName() {
        return this.exclusiveStartTableName;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest)((Object)obj);
        return Objects.equals(this.exclusiveStartTableName(), other.exclusiveStartTableName()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.exclusiveStartTableName() != null) {
            sb.append("ExclusiveStartTableName: ").append(this.exclusiveStartTableName()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExclusiveStartTableName": {
                return Optional.of(clazz.cast(this.exclusiveStartTableName()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String exclusiveStartTableName;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            this.exclusiveStartTableName(model.exclusiveStartTableName);
            this.limit(model.limit);
        }

        public final String getExclusiveStartTableName() {
            return this.exclusiveStartTableName;
        }

        @Override
        public final Builder exclusiveStartTableName(String exclusiveStartTableName) {
            this.exclusiveStartTableName = exclusiveStartTableName;
            return this;
        }

        public final void setExclusiveStartTableName(String exclusiveStartTableName) {
            this.exclusiveStartTableName = exclusiveStartTableName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTablesRequest> {
        public Builder exclusiveStartTableName(String var1);

        public Builder limit(Integer var1);
    }
}

