/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetItemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetItemRequest> {
    private final Map<String, KeysAndAttributes> requestItems;
    private final String returnConsumedCapacity;

    private BatchGetItemRequest(BuilderImpl builder) {
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    public Map<String, KeysAndAttributes> requestItems() {
        return this.requestItems;
    }

    public String returnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.requestItems() == null ? 0 : this.requestItems().hashCode());
        hashCode = 31 * hashCode + (this.returnConsumedCapacity() == null ? 0 : this.returnConsumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemRequest)) {
            return false;
        }
        BatchGetItemRequest other = (BatchGetItemRequest)((Object)obj);
        if (other.requestItems() == null ^ this.requestItems() == null) {
            return false;
        }
        if (other.requestItems() != null && !other.requestItems().equals(this.requestItems())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        return other.returnConsumedCapacity() == null || other.returnConsumedCapacity().equals(this.returnConsumedCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.requestItems() != null) {
            sb.append("RequestItems: ").append(this.requestItems()).append(",");
        }
        if (this.returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, KeysAndAttributes> requestItems;
        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemRequest model) {
            this.setRequestItems(model.requestItems);
            this.setReturnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final Map<String, KeysAndAttributes> getRequestItems() {
            return this.requestItems;
        }

        @Override
        public final Builder requestItems(Map<String, KeysAndAttributes> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copy(requestItems);
            return this;
        }

        public final void setRequestItems(Map<String, KeysAndAttributes> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copy(requestItems);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public BatchGetItemRequest build() {
            return new BatchGetItemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetItemRequest> {
        public Builder requestItems(Map<String, KeysAndAttributes> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);
    }
}

