/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.TimeToLiveSpecificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimeToLiveSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeToLiveSpecification> {
    private final Boolean enabled;
    private final String attributeName;

    private TimeToLiveSpecification(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.attributeName = builder.attributeName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveSpecification)) {
            return false;
        }
        TimeToLiveSpecification other = (TimeToLiveSpecification)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        return other.attributeName() == null || other.attributeName().equals(this.attributeName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeToLiveSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveSpecification model) {
            this.setEnabled(model.enabled);
            this.setAttributeName(model.attributeName);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public TimeToLiveSpecification build() {
            return new TimeToLiveSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeToLiveSpecification> {
        public Builder enabled(Boolean var1);

        public Builder attributeName(String var1);
    }
}

