/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyListCopier;
import software.amazon.awssdk.services.dynamodb.transform.KeysAndAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeysAndAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, KeysAndAttributes> {
    private final List<Map<String, AttributeValue>> keys;
    private final List<String> attributesToGet;
    private final Boolean consistentRead;
    private final String projectionExpression;
    private final Map<String, String> expressionAttributeNames;

    private KeysAndAttributes(BuilderImpl builder) {
        this.keys = builder.keys;
        this.attributesToGet = builder.attributesToGet;
        this.consistentRead = builder.consistentRead;
        this.projectionExpression = builder.projectionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
    }

    public List<Map<String, AttributeValue>> keys() {
        return this.keys;
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keys() == null ? 0 : this.keys().hashCode());
        hashCode = 31 * hashCode + (this.attributesToGet() == null ? 0 : this.attributesToGet().hashCode());
        hashCode = 31 * hashCode + (this.consistentRead() == null ? 0 : this.consistentRead().hashCode());
        hashCode = 31 * hashCode + (this.projectionExpression() == null ? 0 : this.projectionExpression().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeNames() == null ? 0 : this.expressionAttributeNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeysAndAttributes)) {
            return false;
        }
        KeysAndAttributes other = (KeysAndAttributes)obj;
        if (other.keys() == null ^ this.keys() == null) {
            return false;
        }
        if (other.keys() != null && !other.keys().equals(this.keys())) {
            return false;
        }
        if (other.attributesToGet() == null ^ this.attributesToGet() == null) {
            return false;
        }
        if (other.attributesToGet() != null && !other.attributesToGet().equals(this.attributesToGet())) {
            return false;
        }
        if (other.consistentRead() == null ^ this.consistentRead() == null) {
            return false;
        }
        if (other.consistentRead() != null && !other.consistentRead().equals(this.consistentRead())) {
            return false;
        }
        if (other.projectionExpression() == null ^ this.projectionExpression() == null) {
            return false;
        }
        if (other.projectionExpression() != null && !other.projectionExpression().equals(this.projectionExpression())) {
            return false;
        }
        if (other.expressionAttributeNames() == null ^ this.expressionAttributeNames() == null) {
            return false;
        }
        return other.expressionAttributeNames() == null || other.expressionAttributeNames().equals(this.expressionAttributeNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keys() != null) {
            sb.append("Keys: ").append(this.keys()).append(",");
        }
        if (this.attributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.attributesToGet()).append(",");
        }
        if (this.consistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.consistentRead()).append(",");
        }
        if (this.projectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.projectionExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeysAndAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Map<String, AttributeValue>> keys;
        private List<String> attributesToGet;
        private Boolean consistentRead;
        private String projectionExpression;
        private Map<String, String> expressionAttributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(KeysAndAttributes model) {
            this.setKeys(model.keys);
            this.setAttributesToGet(model.attributesToGet);
            this.setConsistentRead(model.consistentRead);
            this.setProjectionExpression(model.projectionExpression);
            this.setExpressionAttributeNames(model.expressionAttributeNames);
        }

        public final Collection<Map<String, AttributeValue>> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<Map<String, AttributeValue>> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Map<String, AttributeValue> ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<Map<String, AttributeValue>> keys) {
            this.keys = KeyListCopier.copy(keys);
        }

        @SafeVarargs
        public final void setKeys(Map<String, AttributeValue> ... keys) {
            this.keys(Arrays.asList(keys));
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        @SafeVarargs
        public final void setAttributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public KeysAndAttributes build() {
            return new KeysAndAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeysAndAttributes> {
        public Builder keys(Collection<Map<String, AttributeValue>> var1);

        public Builder keys(Map<String, AttributeValue> ... var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder consistentRead(Boolean var1);

        public Builder projectionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);
    }
}

