/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.SUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class CustomUnmarshaller
extends SUnmarshaller {
    private final Class<?> targetClass;
    private final Class<? extends DynamoDbMarshaller<?>> unmarshallerClass;

    public CustomUnmarshaller(Class<?> targetClass, Class<? extends DynamoDbMarshaller<?>> unmarshallerClass) {
        this.targetClass = targetClass;
        this.unmarshallerClass = unmarshallerClass;
    }

    private static DynamoDbMarshaller createUnmarshaller(Class<?> clazz) {
        try {
            return (DynamoDbMarshaller)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDbMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDbMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        DynamoDbMarshaller unmarshaller = CustomUnmarshaller.createUnmarshaller(this.unmarshallerClass);
        return unmarshaller.unmarshall(this.targetClass, value.s());
    }
}

