/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.dynamodb.datamodeling.ConversionSchema;
import software.amazon.awssdk.services.dynamodb.datamodeling.ConversionSchemas;
import software.amazon.awssdk.services.dynamodb.datamodeling.ConvertibleType;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperModelFactory;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperTableModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverterFactory;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3Link;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardBeanProperties;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.util.ImmutableObjectUtils;

@SdkInternalApi
final class StandardModelFactories {
    private static final Logger log = LoggerFactory.getLogger(StandardModelFactories.class);

    StandardModelFactories() {
    }

    static DynamoDbMapperModelFactory of(S3Link.Factory s3Links) {
        return new StandardModelFactory(s3Links);
    }

    private static <T> RuleFactory<T> rulesOf(DynamoDbMapperConfig config, S3Link.Factory s3Links, DynamoDbMapperModelFactory models) {
        Rules factory;
        boolean ver1 = config.getConversionSchema() == ConversionSchemas.V1;
        boolean ver2 = config.getConversionSchema() == ConversionSchemas.V2;
        boolean v2Compatible = config.getConversionSchema() == ConversionSchemas.V2_COMPATIBLE;
        DynamoDbTypeConverterFactory.Builder scalars = config.getTypeConverterFactory().override();
        scalars.with(String.class, S3Link.class, s3Links);
        Rules rules = factory = new Rules(scalars.build());
        rules.getClass();
        factory.add(rules.new Rules.NativeType(!ver1));
        Rules rules2 = factory;
        rules2.getClass();
        factory.add(rules2.new Rules.V2CompatibleBool(v2Compatible));
        Rules rules3 = factory;
        rules3.getClass();
        factory.add(rules3.new Rules.NativeBool(ver2));
        Rules rules4 = factory;
        rules4.getClass();
        factory.add(rules4.new Rules.StringScalar(true));
        Rules rules5 = factory;
        rules5.getClass();
        factory.add(rules5.new Rules.NumberScalar(true));
        Rules rules6 = factory;
        rules6.getClass();
        factory.add(rules6.new Rules.BinaryScalar(true));
        Rules rules7 = factory;
        rules7.getClass();
        factory.add(rules7.new Rules.NativeBoolSet(ver2));
        Rules rules8 = factory;
        rules8.getClass();
        factory.add(rules8.new Rules.StringScalarSet(true));
        Rules rules9 = factory;
        rules9.getClass();
        factory.add(rules9.new Rules.NumberScalarSet(true));
        Rules rules10 = factory;
        rules10.getClass();
        factory.add(rules10.new Rules.BinaryScalarSet(true));
        Rules rules11 = factory;
        rules11.getClass();
        factory.add(rules11.new Rules.ObjectSet(ver2));
        Rules rules12 = factory;
        rules12.getClass();
        factory.add(rules12.new Rules.ObjectStringSet(!ver2));
        Rules rules13 = factory;
        rules13.getClass();
        factory.add(rules13.new Rules.ObjectList(!ver1));
        Rules rules14 = factory;
        rules14.getClass();
        factory.add(rules14.new Rules.ObjectMap(!ver1));
        Rules rules15 = factory;
        rules15.getClass();
        factory.add(rules15.new Rules.ObjectDocumentMap(!ver1, models, config));
        return factory;
    }

    private static abstract class AbstractRule<S, T>
    extends DynamoDbTypeConverter.AbstractConverter<AttributeValue, S>
    implements DynamoDbMapperFieldModel.Reflect<AttributeValue, S>,
    Rule<T> {
        protected final DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType;
        protected final boolean supported;

        protected AbstractRule(DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType, boolean supported) {
            this.attributeType = attributeType;
            this.supported = supported;
        }

        @Override
        public boolean isAssignableFrom(ConvertibleType<?> type) {
            return type.attributeType() == null ? this.supported : type.attributeType() == this.attributeType;
        }

        @Override
        public DynamoDbMapperFieldModel.DynamoDbAttributeType getAttributeType() {
            return this.attributeType;
        }

        @Override
        public AttributeValue convert(S o) {
            AttributeValue value = (AttributeValue)AttributeValue.builder().build();
            this.set(value, o);
            return value;
        }

        @Override
        public S unconvert(AttributeValue o) {
            Object value = this.get(o);
            if (value == null && o.nul() == null) {
                throw new DynamoDbMappingException("expected " + (Object)((Object)this.attributeType) + " in value " + o);
            }
            return (S)value;
        }
    }

    private static final class Rules<T>
    implements RuleFactory<T> {
        private final Set<Rule<T>> rules = new LinkedHashSet<Rule<T>>();
        private final DynamoDbTypeConverterFactory scalars;

        private Rules(DynamoDbTypeConverterFactory scalars) {
            this.scalars = scalars;
        }

        private void add(Rule<?> rule) {
            this.rules.add(rule);
        }

        @Override
        public Rule<T> getRule(ConvertibleType<T> type) {
            for (Rule<T> rule : this.rules) {
                if (!rule.isAssignableFrom(type)) continue;
                return rule;
            }
            return new NotSupported();
        }

        private <S> DynamoDbTypeConverter<S, T> getConverter(Class<S> sourceType, ConvertibleType<T> type) {
            return this.scalars.getConverter(sourceType, type.targetType());
        }

        private DynamoDbTypeConverter<AttributeValue, T> getConverter(ConvertibleType<T> type) {
            return new DynamoDbTypeConverter.DelegateConverter<AttributeValue, T>(this.getRule(type).newConverter(type)){

                @Override
                public AttributeValue convert(T o) {
                    return o == null ? (AttributeValue)AttributeValue.builder().nul(true).build() : (AttributeValue)super.convert(o);
                }
            };
        }

        private class NotSupported
        extends AbstractRule<T, T> {
            private NotSupported() {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.NULL, false);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this;
            }

            @Override
            public T get(AttributeValue value) {
                throw new DynamoDbMappingException("not supported; requires @DynamoDBTyped or @DynamoDBTypeConverted");
            }

            @Override
            public void set(AttributeValue value, T o) {
                throw new DynamoDbMappingException("not supported; requires @DynamoDBTyped or @DynamoDBTypeConverted");
            }
        }

        private class ObjectDocumentMap
        extends AbstractRule<Map<String, AttributeValue>, T> {
            private final DynamoDbMapperModelFactory models;
            private final DynamoDbMapperConfig config;

            private ObjectDocumentMap(boolean supported, DynamoDbMapperModelFactory models, DynamoDbMapperConfig config) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.M, supported);
                this.models = models;
                this.config = config;
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return type.attributeType() == this.getAttributeType() && this.supported && !type.is(StandardTypeConverters.Vector.MAP);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(final ConvertibleType<T> type) {
                return this.joinAll(new DynamoDbTypeConverter<Map<String, AttributeValue>, T>(){

                    @Override
                    public Map<String, AttributeValue> convert(T o) {
                        return ObjectDocumentMap.this.models.getTableFactory(ObjectDocumentMap.this.config).getTable(type.targetType()).convert(o);
                    }

                    @Override
                    public T unconvert(Map<String, AttributeValue> o) {
                        return ObjectDocumentMap.this.models.getTableFactory(ObjectDocumentMap.this.config).getTable(type.targetType()).unconvert(o);
                    }
                }, type.typeConverter());
            }

            @Override
            public Map<String, AttributeValue> get(AttributeValue value) {
                return value.m();
            }

            @Override
            public void set(AttributeValue value, Map<String, AttributeValue> o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"m", o);
            }
        }

        private class ObjectMap
        extends AbstractRule<Map<String, AttributeValue>, Map<String, T>> {
            private ObjectMap(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.M, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(1) != null && type.is(StandardTypeConverters.Vector.MAP) && type.param(0).is(StandardTypeConverters.Scalar.STRING);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, Map<String, T>> newConverter(ConvertibleType<Map<String, T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.MAP.join(Rules.this.getConverter(type.param(1))), type.typeConverter());
            }

            @Override
            public Map<String, AttributeValue> get(AttributeValue value) {
                return value.m();
            }

            @Override
            public void set(AttributeValue value, Map<String, AttributeValue> o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"m", o);
            }
        }

        private class ObjectList
        extends AbstractRule<List<AttributeValue>, List<T>> {
            private ObjectList(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.L, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(0) != null && type.is(StandardTypeConverters.Vector.LIST);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, List<T>> newConverter(ConvertibleType<List<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.LIST.join(Rules.this.getConverter(type.param(0))), type.typeConverter());
            }

            @Override
            public List<AttributeValue> get(AttributeValue value) {
                return value.l();
            }

            @Override
            public void set(AttributeValue value, List<AttributeValue> o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"l", o);
            }
        }

        private class NativeBoolSet
        extends ObjectSet {
            private NativeBoolSet(boolean supported) {
                super(supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(0).is(StandardTypeConverters.Scalar.BOOLEAN);
            }

            @Override
            public List<AttributeValue> unconvert(AttributeValue o) {
                if (o.l() == null && o.ns() != null) {
                    return StandardTypeConverters.Vector.LIST.convert(o.ns(), new NativeBool(true).join(Rules.this.scalars.getConverter(Boolean.class, String.class)));
                }
                return (List)super.unconvert(o);
            }
        }

        private class ObjectSet
        extends AbstractRule<List<AttributeValue>, Collection<T>> {
            private ObjectSet(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.L, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(0) != null && type.is(StandardTypeConverters.Vector.SET);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(type.param(0))), type.typeConverter());
            }

            @Override
            public List<AttributeValue> get(AttributeValue value) {
                return value.l();
            }

            @Override
            public void set(AttributeValue value, List<AttributeValue> o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"l", o);
            }
        }

        private class V2CompatibleBool
        extends AbstractRule<String, T> {
            private V2CompatibleBool(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.N, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.is(StandardTypeConverters.Scalar.BOOLEAN);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(String.class, type), type.typeConverter());
            }

            @Override
            public String get(AttributeValue o) {
                if (o.bool() != null) {
                    return o.bool() != false ? "1" : "0";
                }
                return o.n();
            }

            @Override
            public void set(AttributeValue o, String value) {
                ImmutableObjectUtils.setObjectMember((Object)o, (String)"n", (Object)value);
            }
        }

        private class NativeBool
        extends AbstractRule<Boolean, T> {
            private NativeBool(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.BOOL, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.is(StandardTypeConverters.Scalar.BOOLEAN);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(Boolean.class, type), type.typeConverter());
            }

            @Override
            public Boolean get(AttributeValue o) {
                return o.bool();
            }

            @Override
            public void set(AttributeValue o, Boolean value) {
                ImmutableObjectUtils.setObjectMember((Object)o, (String)"bool", (Object)value);
            }

            @Override
            public Boolean unconvert(AttributeValue o) {
                if (o.bool() == null && o.n() != null) {
                    return (Boolean)StandardTypeConverters.Scalar.BOOLEAN.convert(o.n());
                }
                return (Boolean)super.unconvert(o);
            }
        }

        private class ObjectStringSet
        extends StringScalarSet {
            private ObjectStringSet(boolean supported) {
                super(supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return type.attributeType() == null && this.supported && type.is(StandardTypeConverters.Vector.SET);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                log.warn("Marshaling a set of non-String objects to a DynamoDB StringSet. You won't be able to read these objects back out of DynamoDB unless you REALLY know what you're doing: it's probably a bug. If you DO know what you're doing feelfree to ignore this warning, but consider using a custom marshaler for this instead.");
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.scalars.getConverter(String.class, StandardTypeConverters.Scalar.DEFAULT.type())), type.typeConverter());
            }
        }

        private class BinaryScalarSet
        extends AbstractRule<List<ByteBuffer>, Collection<T>> {
            private BinaryScalarSet(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.BS, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.B, StandardTypeConverters.Vector.SET));
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(ByteBuffer.class, type.param(0))), type.typeConverter());
            }

            @Override
            public List<ByteBuffer> get(AttributeValue value) {
                return value.bs();
            }

            @Override
            public void set(AttributeValue value, List<ByteBuffer> o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"bs", o);
            }
        }

        private class NumberScalarSet
        extends AbstractRule<List<String>, Collection<T>> {
            private NumberScalarSet(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.NS, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.N, StandardTypeConverters.Vector.SET));
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(String.class, type.param(0))), type.typeConverter());
            }

            @Override
            public List<String> get(AttributeValue value) {
                return value.ns();
            }

            @Override
            public void set(AttributeValue value, List<String> o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"ns", o);
            }
        }

        private class StringScalarSet
        extends AbstractRule<List<String>, Collection<T>> {
            private StringScalarSet(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.SS, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.S, StandardTypeConverters.Vector.SET));
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(String.class, type.param(0))), type.typeConverter());
            }

            @Override
            public List<String> get(AttributeValue value) {
                return value.ss();
            }

            @Override
            public void set(AttributeValue value, List<String> o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"ss", o);
            }
        }

        private class BinaryScalar
        extends AbstractRule<ByteBuffer, T> {
            private BinaryScalar(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.B, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.B));
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(ByteBuffer.class, type), type.typeConverter());
            }

            @Override
            public ByteBuffer get(AttributeValue value) {
                return value.b();
            }

            @Override
            public void set(AttributeValue value, ByteBuffer o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"b", (Object)o);
            }
        }

        private class NumberScalar
        extends AbstractRule<String, T> {
            private NumberScalar(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.N, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.N));
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(String.class, type), type.typeConverter());
            }

            @Override
            public String get(AttributeValue value) {
                return value.n();
            }

            @Override
            public void set(AttributeValue value, String o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"n", (Object)o);
            }
        }

        private class StringScalar
        extends AbstractRule<String, T> {
            private StringScalar(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.S, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.S));
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(String.class, type), type.typeConverter());
            }

            @Override
            public String get(AttributeValue value) {
                return value.s();
            }

            @Override
            public void set(AttributeValue value, String o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"s", (Object)o);
            }

            @Override
            public AttributeValue convert(String o) {
                return o.length() == 0 ? null : super.convert(o);
            }
        }

        private class NativeType
        extends AbstractRule<AttributeValue, T> {
            private NativeType(boolean supported) {
                super(DynamoDbMapperFieldModel.DynamoDbAttributeType.NULL, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return this.supported && type.is(AttributeValue.class);
            }

            @Override
            public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(type.typeConverter());
            }

            @Override
            public AttributeValue get(AttributeValue o) {
                return o;
            }

            @Override
            public void set(AttributeValue value, AttributeValue o) {
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"s", (Object)o.s());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"n", (Object)o.n());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"b", (Object)o.b());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"ss", o.ss());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"ns", o.ns());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"bs", o.bs());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"bool", (Object)o.bool());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"l", o.l());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"m", o.m());
                ImmutableObjectUtils.setObjectMember((Object)value, (String)"nul", (Object)o.nul());
            }
        }
    }

    private static final class FieldBuilder<T, V>
    extends DynamoDbMapperFieldModel.Builder<T, V> {
        private FieldBuilder(Class<T> clazz, StandardBeanProperties.Bean<T, V> bean, Rule<V> rule) {
            super(clazz, bean.properties());
            if (bean.type().attributeType() != null) {
                this.with(bean.type().attributeType());
            } else {
                this.with(rule.getAttributeType());
            }
            this.with(rule.newConverter(bean.type()));
            this.with(bean.reflect());
        }
    }

    private static final class TableBuilder<T>
    extends DynamoDbMapperTableModel.Builder<T> {
        private TableBuilder(Class<T> clazz, StandardBeanProperties.Beans<T> beans, RuleFactory<Object> rules) {
            super(clazz, beans.properties());
            for (StandardBeanProperties.Bean<T, Object> bean : beans.map().values()) {
                try {
                    this.with(new FieldBuilder(clazz, bean, rules.getRule(bean.type())).build());
                }
                catch (RuntimeException e) {
                    throw new DynamoDbMappingException(String.format("%s[%s] could not be mapped for type %s", clazz.getSimpleName(), bean.properties().attributeName(), bean.type()), e);
                }
            }
        }

        private TableBuilder(Class<T> clazz, RuleFactory<Object> rules) {
            this(clazz, StandardBeanProperties.of(clazz), rules);
        }
    }

    private static final class StandardTableFactory
    implements DynamoDbMapperModelFactory.TableFactory {
        private final ConcurrentMap<Class<?>, DynamoDbMapperTableModel<?>> cache = new ConcurrentHashMap();
        private final RuleFactory<Object> rules;

        private StandardTableFactory(RuleFactory<Object> rules) {
            this.rules = rules;
        }

        @Override
        public <T> DynamoDbMapperTableModel<T> getTable(Class<T> clazz) {
            if (!this.cache.containsKey(clazz)) {
                this.cache.putIfAbsent(clazz, new TableBuilder(clazz, this.rules).build());
            }
            return (DynamoDbMapperTableModel)this.cache.get(clazz);
        }
    }

    private static final class StandardModelFactory
    implements DynamoDbMapperModelFactory {
        private final ConcurrentMap<ConversionSchema, DynamoDbMapperModelFactory.TableFactory> cache = new ConcurrentHashMap<ConversionSchema, DynamoDbMapperModelFactory.TableFactory>();
        private final S3Link.Factory s3Links;

        private StandardModelFactory(S3Link.Factory s3Links) {
            this.s3Links = s3Links;
        }

        @Override
        public DynamoDbMapperModelFactory.TableFactory getTableFactory(DynamoDbMapperConfig config) {
            ConversionSchema schema = config.getConversionSchema();
            if (!this.cache.containsKey(schema)) {
                ConversionSchemas.ItemConverterRuleFactory rules = StandardModelFactories.rulesOf(config, this.s3Links, this);
                rules = new ConversionSchemas.ItemConverterRuleFactory(config, this.s3Links, rules);
                this.cache.putIfAbsent(schema, new StandardTableFactory(rules));
            }
            return (DynamoDbMapperModelFactory.TableFactory)this.cache.get(schema);
        }
    }

    static interface RuleFactory<T> {
        public Rule<T> getRule(ConvertibleType<T> var1);
    }

    static interface Rule<T> {
        public boolean isAssignableFrom(ConvertibleType<?> var1);

        public DynamoDbTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> var1);

        public DynamoDbMapperFieldModel.DynamoDbAttributeType getAttributeType();
    }
}

