/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3ClientCache;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.sync.RequestBody;
import software.amazon.awssdk.sync.StreamingResponseHandler;
import software.amazon.awssdk.util.json.Jackson;

public class S3Link {
    private final S3ClientCache s3cc;
    private final Id id;

    S3Link(S3ClientCache s3cc, String bucketName, String key) {
        this(s3cc, new Id(bucketName, key));
    }

    S3Link(S3ClientCache s3cc, String region, String bucketName, String key) {
        this(s3cc, new Id(region, bucketName, key));
    }

    private S3Link(S3ClientCache s3cc, Id id) {
        this.s3cc = s3cc;
        this.id = id;
        if (s3cc == null) {
            throw new IllegalArgumentException("S3ClientCache must be configured for use with S3Link");
        }
        if (id == null || id.bucket() == null || id.getKey() == null) {
            throw new IllegalArgumentException("Bucket and key must be specified for S3Link");
        }
    }

    public static S3Link fromJson(S3ClientCache s3cc, String json) {
        Id id = (Id)Jackson.fromJsonString((String)json, Id.class);
        return new S3Link(s3cc, id);
    }

    private static String convertRegionToString(Region region, String bucketName) {
        return region.value();
    }

    public String getKey() {
        return this.id.getKey();
    }

    public String bucketName() {
        return this.id.bucket();
    }

    public Region s3Region() {
        return Region.of((String)this.getRegion());
    }

    public String getRegion() {
        return this.id.getRegionId() == null ? "us-east-1" : this.id.getRegionId();
    }

    public String toJson() {
        return this.id.toJson();
    }

    public S3Client getAmazonS3Client() {
        return this.s3cc.getClient(this.getRegion());
    }

    public PutObjectResponse uploadFrom(File source) {
        return this.uploadFrom0(source, null);
    }

    public PutObjectResponse uploadFrom(File source, RequestMetricCollector requestMetricCollector) {
        return this.uploadFrom0(source, requestMetricCollector);
    }

    private PutObjectResponse uploadFrom0(File source, RequestMetricCollector requestMetricCollector) {
        return this.getAmazonS3Client().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName()).key(this.getKey()).build(), RequestBody.of((File)source));
    }

    public PutObjectResponse uploadFrom(byte[] buffer) {
        return this.uploadFrom0(buffer, null);
    }

    public PutObjectResponse uploadFrom(byte[] buffer, RequestMetricCollector requestMetricCollector) {
        return this.uploadFrom0(buffer, requestMetricCollector);
    }

    private PutObjectResponse uploadFrom0(byte[] buffer, RequestMetricCollector requestMetricCollector) {
        return this.getAmazonS3Client().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName()).key(this.getKey()).contentLength(Long.valueOf(buffer.length)).build(), RequestBody.of((byte[])buffer));
    }

    public void setAcl(ObjectCannedACL acl) {
        this.setAcl0(acl, null);
    }

    public void setAcl(ObjectCannedACL acl, RequestMetricCollector col) {
        this.setAcl0(acl, col);
    }

    private void setAcl0(ObjectCannedACL acl, RequestMetricCollector col) {
        this.getAmazonS3Client().putObjectAcl((PutObjectAclRequest)PutObjectAclRequest.builder().bucket(this.bucketName()).key(this.getKey()).acl(acl).build());
    }

    public void setAcl(AccessControlPolicy acl, RequestMetricCollector requestMetricCollector) {
        this.setAcl0(acl, requestMetricCollector);
    }

    private void setAcl0(AccessControlPolicy acl, RequestMetricCollector requestMetricCollector) {
        this.getAmazonS3Client().putObjectAcl((PutObjectAclRequest)PutObjectAclRequest.builder().accessControlPolicy(acl).bucket(this.bucketName()).key(this.getKey()).build());
    }

    public GetObjectResponse downloadTo(File destination) {
        return this.downloadTo0(destination, null);
    }

    public GetObjectResponse downloadTo(File destination, RequestMetricCollector requestMetricCollector) {
        return this.downloadTo0(destination, requestMetricCollector);
    }

    private GetObjectResponse downloadTo0(File destination, RequestMetricCollector requestMetricCollector) {
        GetObjectResponse response = (GetObjectResponse)this.getAmazonS3Client().getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName()).key(this.getKey()).build(), StreamingResponseHandler.toFile((Path)destination.toPath()));
        return response;
    }

    public GetObjectResponse downloadTo(OutputStream output) {
        return this.downloadTo0(output, null);
    }

    public GetObjectResponse downloadTo(OutputStream output, RequestMetricCollector requestMetricCollector) {
        return this.downloadTo0(output, requestMetricCollector);
    }

    private GetObjectResponse downloadTo0(OutputStream output, RequestMetricCollector requestMetricCollector) {
        GetObjectResponse response = (GetObjectResponse)this.getAmazonS3Client().getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName()).key(this.getKey()).build(), StreamingResponseHandler.toOutputStream((OutputStream)output));
        return response;
    }

    public static final class Factory
    implements DynamoDbTypeConverter<String, S3Link> {
        static final Factory DEFAULT = new Factory(null);
        private final S3ClientCache s3cc;

        public Factory(S3ClientCache s3cc) {
            this.s3cc = s3cc;
        }

        public static Factory of(AwsCredentialsProvider provider) {
            return provider == null ? DEFAULT : new Factory(new S3ClientCache(provider));
        }

        public S3Link createS3Link(Region s3region, String bucketName, String key) {
            return this.createS3Link(S3Link.convertRegionToString(s3region, bucketName), bucketName, key);
        }

        public S3Link createS3Link(String s3region, String bucketName, String key) {
            if (this.s3ClientCache() == null) {
                throw new IllegalStateException("Mapper must be constructed with S3 AWS Credentials to create S3Link");
            }
            return new S3Link(this.s3ClientCache(), s3region, bucketName, key);
        }

        public S3ClientCache s3ClientCache() {
            return this.s3cc;
        }

        @Override
        public String convert(S3Link o) {
            return o.bucketName() == null || o.getKey() == null ? null : o.toJson();
        }

        @Override
        public S3Link unconvert(String o) {
            return S3Link.fromJson(this.s3ClientCache(), o);
        }
    }

    private static class S3 {
        @JsonProperty(value="bucket")
        private String bucket;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="region")
        private String regionId;

        S3() {
        }

        S3(String bucket, String key) {
            this(null, bucket, key);
        }

        S3(String region, String bucket, String key) {
            this.regionId = region;
            this.bucket = bucket;
            this.key = key;
        }

        @JsonProperty(value="bucket")
        public String bucket() {
            return this.bucket;
        }

        @JsonProperty(value="key")
        public String getKey() {
            return this.key;
        }

        @JsonProperty(value="region")
        public String getRegionId() {
            return this.regionId;
        }
    }

    static class Id {
        @JsonProperty(value="s3")
        private S3 s3;

        Id() {
        }

        Id(String bucketName, String key) {
            this.s3 = new S3(bucketName, key);
        }

        Id(String region, String bucketName, String key) {
            this.s3 = new S3(region, bucketName, key);
        }

        Id(S3 s3) {
            this.s3 = s3;
        }

        @JsonProperty(value="s3")
        public S3 s3() {
            return this.s3;
        }

        @JsonIgnore
        public String getRegionId() {
            return this.s3.getRegionId();
        }

        @JsonIgnore
        public String bucket() {
            return this.s3.bucket();
        }

        @JsonIgnore
        public String getKey() {
            return this.s3.getKey();
        }

        String toJson() {
            return Jackson.toJsonString((Object)this);
        }
    }
}

