/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;

public abstract class DynamoDbTypeConverterFactory {
    public static DynamoDbTypeConverterFactory standard() {
        return StandardTypeConverters.factory();
    }

    public abstract <S, T> DynamoDbTypeConverter<S, T> getConverter(Class<S> var1, Class<T> var2);

    public final Builder override() {
        return new Builder(this);
    }

    private static final class Key<S, T>
    extends AbstractMap.SimpleImmutableEntry<Class<S>, Class<T>> {
        private static final long serialVersionUID = -1L;

        private Key(Class<S> sourceType, Class<T> targetType) {
            super(sourceType, targetType);
        }

        public static <S, T> Key<S, T> of(Class<S> sourceType, Class<T> targetType) {
            return new Key<S, T>(sourceType, targetType);
        }

        public boolean isAssignableFrom(Class<?> sourceType, Class<?> targetType) {
            return ((Class)this.getKey()).isAssignableFrom(sourceType) && ((Class)this.getValue()).isAssignableFrom(targetType);
        }
    }

    private static final class ConverterMap
    extends LinkedHashMap<Key<?, ?>, DynamoDbTypeConverter<?, ?>> {
        private static final long serialVersionUID = -1L;

        private ConverterMap() {
        }

        public <S, T> void put(Class<S> sourceType, Class<T> targetType, DynamoDbTypeConverter<? extends S, ? extends T> converter) {
            this.put(Key.of(sourceType, targetType), converter);
        }

        public <S, T> DynamoDbTypeConverter<S, T> get(Class<S> sourceType, Class<T> targetType) {
            for (Map.Entry entry : this.entrySet()) {
                if (!((Key)entry.getKey()).isAssignableFrom(sourceType, targetType)) continue;
                return (DynamoDbTypeConverter)entry.getValue();
            }
            return null;
        }
    }

    private static class OverrideFactory
    extends DelegateFactory {
        private final ConverterMap overrides;

        OverrideFactory(DynamoDbTypeConverterFactory defaults, ConverterMap overrides) {
            super(defaults);
            this.overrides = overrides;
        }

        @Override
        public <S, T> DynamoDbTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            DynamoDbTypeConverter<S, T> converter = this.overrides.get(sourceType, targetType);
            if (converter == null) {
                converter = super.getConverter(sourceType, targetType);
            }
            return converter;
        }
    }

    public static class DelegateFactory
    extends DynamoDbTypeConverterFactory {
        private final DynamoDbTypeConverterFactory delegate;

        public DelegateFactory(DynamoDbTypeConverterFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public <S, T> DynamoDbTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            return this.delegate.getConverter(sourceType, targetType);
        }
    }

    public static final class Builder {
        private final ConverterMap overrides = new ConverterMap();
        private final DynamoDbTypeConverterFactory defaults;

        private Builder(DynamoDbTypeConverterFactory defaults) {
            this.defaults = defaults;
        }

        public <S, T> Builder with(Class<S> sourceType, Class<T> targetType, DynamoDbTypeConverter<? extends S, ? extends T> converter) {
            if (StandardTypeConverters.Vector.SET.is(sourceType) || StandardTypeConverters.Vector.LIST.is(sourceType) || StandardTypeConverters.Vector.MAP.is(sourceType)) {
                throw new DynamoDbMappingException("type [" + sourceType + "] is not supported; type-converter factory only supports scalar conversions");
            }
            this.overrides.put(sourceType, targetType, converter);
            return this;
        }

        public DynamoDbTypeConverterFactory build() {
            return new OverrideFactory(this.defaults, this.overrides);
        }
    }
}

