/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverted;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTyped;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;

@DynamoDbTypeConverted(converter=Converter.class)
@DynamoDbTyped(value=DynamoDbMapperFieldModel.DynamoDbAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDbTypeConvertedTimestamp {
    public String pattern() default "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public String timeZone() default "UTC";

    public static final class Converter<T>
    implements DynamoDbTypeConverter<String, T> {
        private final DynamoDbTypeConverter<DateTime, T> converter;
        private final DateTimeFormatter formatter;

        Converter(Class<T> targetType, DynamoDbTypeConvertedTimestamp annotation) {
            this.formatter = DateTimeFormat.forPattern((String)annotation.pattern()).withZone(DateTimeZone.forTimeZone((TimeZone)((TimeZone)StandardTypeConverters.Scalar.TIME_ZONE.convert(annotation.timeZone()))));
            this.converter = StandardTypeConverters.factory().getConverter(DateTime.class, targetType);
        }

        @Override
        public String convert(T object) {
            return this.formatter.print((ReadableInstant)this.converter.convert(object));
        }

        @Override
        public T unconvert(String object) {
            return this.converter.unconvert(this.formatter.parseDateTime(object));
        }
    }
}

