/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDb;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverted;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTyped;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardBeanProperties;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;

@DynamoDb
@DynamoDbTypeConverted(converter=Converter.class)
@DynamoDbTyped(value=DynamoDbMapperFieldModel.DynamoDbAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDbDelimited {
    public char delimiter() default 124;

    public String[] attributeNames();

    public static final class Converter<T>
    implements DynamoDbTypeConverter<String, T> {
        private final Field<T, Object>[] fields;
        private final Class<T> targetType;
        private final String delimiter;

        Converter(Class<T> targetType, DynamoDbDelimited annotation) {
            StandardBeanProperties.BeanMap beans = new StandardBeanProperties.BeanMap(targetType, true);
            String[] names = annotation.attributeNames();
            if (names.length <= 1) {
                throw new DynamoDbMappingException(targetType + " missing attributeNames in @DynamoDBDelimited; must specify two or more attribute names");
            }
            this.delimiter = String.valueOf(annotation.delimiter());
            this.fields = new Field[names.length];
            this.targetType = targetType;
            for (int i = 0; i < this.fields.length; ++i) {
                if (!beans.containsKey(names[i])) {
                    throw new DynamoDbMappingException(targetType + " does not map %s on model " + names[i]);
                }
                this.fields[i] = new Field(targetType, (StandardBeanProperties.Bean)beans.get(names[i]));
            }
        }

        @Override
        public String convert(T object) {
            StringBuilder string = new StringBuilder();
            for (int i = 0; i < this.fields.length; ++i) {
                String value;
                if (i > 0) {
                    string.append(this.delimiter);
                }
                if ((value = ((Field)this.fields[i]).get(object)) == null) continue;
                if (value.contains(this.delimiter)) {
                    throw new DynamoDbMappingException(String.format("%s[%s] field value \"%s\" must not contain delimiter %s", this.targetType, ((Field)this.fields[i]).bean.properties().attributeName(), value, this.delimiter));
                }
                string.append(value);
            }
            return string.length() < this.fields.length ? null : string.toString();
        }

        @Override
        public T unconvert(String string) {
            T object = StandardBeanProperties.DeclaringReflect.newInstance(this.targetType);
            String[] values = string.split(Pattern.quote(this.delimiter));
            int its = Math.min(this.fields.length, values.length);
            for (int i = 0; i < its; ++i) {
                ((Field)this.fields[i]).set(object, values[i]);
            }
            return object;
        }

        private static final class Field<T, V> {
            private final DynamoDbTypeConverter<String, V> converter;
            private final StandardBeanProperties.Bean<T, V> bean;

            private Field(Class<T> type, StandardBeanProperties.Bean<T, V> bean) {
                this.converter = bean.type().typeConverter() == null ? StandardTypeConverters.factory().getConverter(String.class, bean.type().targetType()) : bean.type().typeConverter();
                this.bean = bean;
            }

            private String get(T object) {
                V value = this.bean.reflect().get(object);
                if (value == null) {
                    return null;
                }
                return this.converter.convert(value);
            }

            private void set(T object, String string) {
                V value;
                if (!string.isEmpty() && (value = this.converter.unconvert(string)) != null) {
                    this.bean.reflect().set(object, value);
                }
            }
        }
    }
}

