/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.transform.AutoScalingPolicyUpdateUnmarshaller;

public class AutoScalingSettingsUpdateUnmarshaller
implements Unmarshaller<AutoScalingSettingsUpdate, JsonUnmarshallerContext> {
    private static final AutoScalingSettingsUpdateUnmarshaller INSTANCE = new AutoScalingSettingsUpdateUnmarshaller();

    public AutoScalingSettingsUpdate unmarshall(JsonUnmarshallerContext context) throws Exception {
        AutoScalingSettingsUpdate.Builder autoScalingSettingsUpdateBuilder = AutoScalingSettingsUpdate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MinimumUnits", targetDepth)) {
                    context.nextToken();
                    autoScalingSettingsUpdateBuilder.minimumUnits((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaximumUnits", targetDepth)) {
                    context.nextToken();
                    autoScalingSettingsUpdateBuilder.maximumUnits((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoScalingDisabled", targetDepth)) {
                    context.nextToken();
                    autoScalingSettingsUpdateBuilder.autoScalingDisabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoScalingRoleArn", targetDepth)) {
                    context.nextToken();
                    autoScalingSettingsUpdateBuilder.autoScalingRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ScalingPolicyUpdate", targetDepth)) {
                    context.nextToken();
                    autoScalingSettingsUpdateBuilder.scalingPolicyUpdate(AutoScalingPolicyUpdateUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AutoScalingSettingsUpdate)autoScalingSettingsUpdateBuilder.build();
    }

    public static AutoScalingSettingsUpdateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

