/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutoScalingSettingsUpdateMarshaller {
    private static final MarshallingInfo<Long> MINIMUMUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimumUnits").isBinary(false).build();
    private static final MarshallingInfo<Long> MAXIMUMUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumUnits").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AUTOSCALINGDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingDisabled").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOSCALINGROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingRoleArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCALINGPOLICYUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalingPolicyUpdate").isBinary(false).build();
    private static final AutoScalingSettingsUpdateMarshaller INSTANCE = new AutoScalingSettingsUpdateMarshaller();

    private AutoScalingSettingsUpdateMarshaller() {
    }

    public static AutoScalingSettingsUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingSettingsUpdate autoScalingSettingsUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)autoScalingSettingsUpdate, (String)"autoScalingSettingsUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)autoScalingSettingsUpdate.minimumUnits(), MINIMUMUNITS_BINDING);
            protocolMarshaller.marshall((Object)autoScalingSettingsUpdate.maximumUnits(), MAXIMUMUNITS_BINDING);
            protocolMarshaller.marshall((Object)autoScalingSettingsUpdate.autoScalingDisabled(), AUTOSCALINGDISABLED_BINDING);
            protocolMarshaller.marshall((Object)autoScalingSettingsUpdate.autoScalingRoleArn(), AUTOSCALINGROLEARN_BINDING);
            protocolMarshaller.marshall((Object)autoScalingSettingsUpdate.scalingPolicyUpdate(), SCALINGPOLICYUPDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

