/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutoScalingPolicyDescriptionMarshaller {
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETTRACKINGSCALINGPOLICYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetTrackingScalingPolicyConfiguration").isBinary(false).build();
    private static final AutoScalingPolicyDescriptionMarshaller INSTANCE = new AutoScalingPolicyDescriptionMarshaller();

    private AutoScalingPolicyDescriptionMarshaller() {
    }

    public static AutoScalingPolicyDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingPolicyDescription autoScalingPolicyDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)autoScalingPolicyDescription, (String)"autoScalingPolicyDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)autoScalingPolicyDescription.policyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall((Object)autoScalingPolicyDescription.targetTrackingScalingPolicyConfiguration(), TARGETTRACKINGSCALINGPOLICYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

