/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClient;

public class ListStreamsPublisher
implements SdkPublisher<ListStreamsResponse> {
    private final DynamoDbStreamsAsyncClient client;
    private final ListStreamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamsPublisher(DynamoDbStreamsAsyncClient client, ListStreamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamsPublisher(DynamoDbStreamsAsyncClient client, ListStreamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Stream> streams() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streams() != null) {
                return response.streams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListStreamsPublisher resume(ListStreamsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStreamsPublisher(this.client, (ListStreamsRequest)((Object)this.firstRequest.toBuilder().exclusiveStartStreamArn(lastSuccessfulPage.lastEvaluatedStreamArn()).build()));
        }
        return new ListStreamsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListStreamsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListStreamsResponseFetcher
    implements AsyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.lastEvaluatedStreamArn());
        }

        public CompletableFuture<ListStreamsResponse> nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsPublisher.this.client.listStreams(ListStreamsPublisher.this.firstRequest);
            }
            return ListStreamsPublisher.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsPublisher.this.firstRequest.toBuilder().exclusiveStartStreamArn(previousPage.lastEvaluatedStreamArn()).build()));
        }
    }
}

