/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.model.ShardDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.StreamStatus;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.transform.StreamDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamDescription> {
    private final String streamArn;
    private final String streamLabel;
    private final String streamStatus;
    private final String streamViewType;
    private final Instant creationRequestDateTime;
    private final String tableName;
    private final List<KeySchemaElement> keySchema;
    private final List<Shard> shards;
    private final String lastEvaluatedShardId;

    private StreamDescription(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.streamLabel = builder.streamLabel;
        this.streamStatus = builder.streamStatus;
        this.streamViewType = builder.streamViewType;
        this.creationRequestDateTime = builder.creationRequestDateTime;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.shards = builder.shards;
        this.lastEvaluatedShardId = builder.lastEvaluatedShardId;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public String streamLabel() {
        return this.streamLabel;
    }

    public StreamStatus streamStatus() {
        return StreamStatus.fromValue(this.streamStatus);
    }

    public String streamStatusAsString() {
        return this.streamStatus;
    }

    public StreamViewType streamViewType() {
        return StreamViewType.fromValue(this.streamViewType);
    }

    public String streamViewTypeAsString() {
        return this.streamViewType;
    }

    public Instant creationRequestDateTime() {
        return this.creationRequestDateTime;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public List<Shard> shards() {
        return this.shards;
    }

    public String lastEvaluatedShardId() {
        return this.lastEvaluatedShardId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamViewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationRequestDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.shards());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedShardId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.streamLabel(), other.streamLabel()) && Objects.equals(this.streamStatusAsString(), other.streamStatusAsString()) && Objects.equals(this.streamViewTypeAsString(), other.streamViewTypeAsString()) && Objects.equals(this.creationRequestDateTime(), other.creationRequestDateTime()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.shards(), other.shards()) && Objects.equals(this.lastEvaluatedShardId(), other.lastEvaluatedShardId());
    }

    public String toString() {
        return ToString.builder((String)"StreamDescription").add("StreamArn", (Object)this.streamArn()).add("StreamLabel", (Object)this.streamLabel()).add("StreamStatus", (Object)this.streamStatusAsString()).add("StreamViewType", (Object)this.streamViewTypeAsString()).add("CreationRequestDateTime", (Object)this.creationRequestDateTime()).add("TableName", (Object)this.tableName()).add("KeySchema", this.keySchema()).add("Shards", this.shards()).add("LastEvaluatedShardId", (Object)this.lastEvaluatedShardId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "StreamLabel": {
                return Optional.ofNullable(clazz.cast(this.streamLabel()));
            }
            case "StreamStatus": {
                return Optional.ofNullable(clazz.cast(this.streamStatusAsString()));
            }
            case "StreamViewType": {
                return Optional.ofNullable(clazz.cast(this.streamViewTypeAsString()));
            }
            case "CreationRequestDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationRequestDateTime()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "Shards": {
                return Optional.ofNullable(clazz.cast(this.shards()));
            }
            case "LastEvaluatedShardId": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedShardId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private String streamLabel;
        private String streamStatus;
        private String streamViewType;
        private Instant creationRequestDateTime;
        private String tableName;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();
        private String lastEvaluatedShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescription model) {
            this.streamArn(model.streamArn);
            this.streamLabel(model.streamLabel);
            this.streamStatus(model.streamStatus);
            this.streamViewType(model.streamViewType);
            this.creationRequestDateTime(model.creationRequestDateTime);
            this.tableName(model.tableName);
            this.keySchema(model.keySchema);
            this.shards(model.shards);
            this.lastEvaluatedShardId(model.lastEvaluatedShardId);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getStreamLabel() {
            return this.streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
            return this;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public final Instant getCreationRequestDateTime() {
            return this.creationRequestDateTime;
        }

        @Override
        public final Builder creationRequestDateTime(Instant creationRequestDateTime) {
            this.creationRequestDateTime = creationRequestDateTime;
            return this;
        }

        public final void setCreationRequestDateTime(Instant creationRequestDateTime) {
            this.creationRequestDateTime = creationRequestDateTime;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Collection<Shard.Builder> getShards() {
            return this.shards != null ? (Collection)this.shards.stream().map(Shard::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardDescriptionListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard ... shards) {
            this.shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder> ... shards) {
            this.shards(Stream.of(shards).map(c -> (Shard)((Shard.Builder)Shard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardDescriptionListCopier.copyFromBuilder(shards);
        }

        public final String getLastEvaluatedShardId() {
            return this.lastEvaluatedShardId;
        }

        @Override
        public final Builder lastEvaluatedShardId(String lastEvaluatedShardId) {
            this.lastEvaluatedShardId = lastEvaluatedShardId;
            return this;
        }

        public final void setLastEvaluatedShardId(String lastEvaluatedShardId) {
            this.lastEvaluatedShardId = lastEvaluatedShardId;
        }

        public StreamDescription build() {
            return new StreamDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamDescription> {
        public Builder streamArn(String var1);

        public Builder streamLabel(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);

        public Builder creationRequestDateTime(Instant var1);

        public Builder tableName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder shards(Collection<Shard> var1);

        public Builder shards(Shard ... var1);

        public Builder shards(Consumer<Shard.Builder> ... var1);

        public Builder lastEvaluatedShardId(String var1);
    }
}

