/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.transform.KeySchemaElementMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeySchemaElement
implements StructuredPojo,
ToCopyableBuilder<Builder, KeySchemaElement> {
    private final String attributeName;
    private final String keyType;

    private KeySchemaElement(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.keyType = builder.keyType;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public String keyTypeAsString() {
        return this.keyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySchemaElement)) {
            return false;
        }
        KeySchemaElement other = (KeySchemaElement)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"KeySchemaElement").add("AttributeName", (Object)this.attributeName()).add("KeyType", (Object)this.keyTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeySchemaElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(KeySchemaElement model) {
            this.attributeName(model.attributeName);
            this.keyType(model.keyType);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public KeySchemaElement build() {
            return new KeySchemaElement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeySchemaElement> {
        public Builder attributeName(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);
    }
}

