/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.dynamodb.DynamoDBAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;

public class BatchGetItemPublisher
implements SdkPublisher<BatchGetItemResponse> {
    private final DynamoDBAsyncClient client;
    private final BatchGetItemRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetItemPublisher(DynamoDBAsyncClient client, BatchGetItemRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetItemPublisher(DynamoDBAsyncClient client, BatchGetItemRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetItemResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetItemResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Map.Entry<String, List<Map<String, AttributeValue>>>> responses() {
        Function<BatchGetItemResponse, Iterator> getIterator = response -> {
            if (response != null && response.responses() != null) {
                return response.responses().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new BatchGetItemResponseFetcher(), getIterator, this.isLastPage);
    }

    public final BatchGetItemPublisher resume(BatchGetItemResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new BatchGetItemPublisher(this.client, (BatchGetItemRequest)((Object)this.firstRequest.toBuilder().requestItems(lastSuccessfulPage.unprocessedKeys()).build()));
        }
        return new BatchGetItemPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super BatchGetItemResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class BatchGetItemResponseFetcher
    implements AsyncPageFetcher<BatchGetItemResponse> {
        private BatchGetItemResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetItemResponse previousPage) {
            return previousPage.unprocessedKeys() != null;
        }

        public CompletableFuture<BatchGetItemResponse> nextPage(BatchGetItemResponse previousPage) {
            if (previousPage == null) {
                return BatchGetItemPublisher.this.client.batchGetItem(BatchGetItemPublisher.this.firstRequest);
            }
            return BatchGetItemPublisher.this.client.batchGetItem((BatchGetItemRequest)((Object)BatchGetItemPublisher.this.firstRequest.toBuilder().requestItems(previousPage.unprocessedKeys()).build()));
        }
    }
}

