/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBException;
import software.amazon.awssdk.services.dynamodb.model.ExpiredIteratorException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.dynamodb.transform.DescribeStreamResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetRecordsResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetShardIteratorResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListStreamsResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsClient;
import software.amazon.awssdk.services.dynamodbstreams.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.dynamodbstreams.transform.GetRecordsRequestMarshaller;
import software.amazon.awssdk.services.dynamodbstreams.transform.GetShardIteratorRequestMarshaller;
import software.amazon.awssdk.services.dynamodbstreams.transform.ListStreamsRequestMarshaller;

@SdkInternalApi
final class DefaultDynamoDBStreamsClient
implements DynamoDBStreamsClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultDynamoDBStreamsClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkBaseException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeStreamResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeStreamResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeStreamRequest).withMarshaller((Marshaller)new DescribeStreamRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, SdkBaseException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetRecordsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetRecordsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getRecordsRequest).withMarshaller((Marshaller)new GetRecordsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, SdkBaseException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetShardIteratorResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetShardIteratorResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getShardIteratorRequest).withMarshaller((Marshaller)new GetShardIteratorRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkBaseException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListStreamsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListStreamsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listStreamsRequest).withMarshaller((Marshaller)new ListStreamsRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DynamoDBException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrimmedDataAccessException").withModeledClass(TrimmedDataAccessException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredIteratorException").withModeledClass(ExpiredIteratorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

