/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.Projection;

@SdkInternalApi
public class ProjectionMarshaller {
    private static final MarshallingInfo<String> PROJECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectionType").build();
    private static final MarshallingInfo<List> NONKEYATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonKeyAttributes").build();
    private static final ProjectionMarshaller instance = new ProjectionMarshaller();

    public static ProjectionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Projection projection, ProtocolMarshaller protocolMarshaller) {
        if (projection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)projection.projectionType(), PROJECTIONTYPE_BINDING);
            protocolMarshaller.marshall(projection.nonKeyAttributes(), NONKEYATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

