/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetricsPerTableCopier;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteItemResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchWriteItemResponse> {
    private final Map<String, List<WriteRequest>> unprocessedItems;
    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchWriteItemResponse(BuilderImpl builder) {
        this.unprocessedItems = builder.unprocessedItems;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public Map<String, List<WriteRequest>> unprocessedItems() {
        return this.unprocessedItems;
    }

    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.unprocessedItems() == null ? 0 : this.unprocessedItems().hashCode());
        hashCode = 31 * hashCode + (this.itemCollectionMetrics() == null ? 0 : this.itemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + (this.consumedCapacity() == null ? 0 : this.consumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemResponse)) {
            return false;
        }
        BatchWriteItemResponse other = (BatchWriteItemResponse)((Object)obj);
        if (other.unprocessedItems() == null ^ this.unprocessedItems() == null) {
            return false;
        }
        if (other.unprocessedItems() != null && !other.unprocessedItems().equals(this.unprocessedItems())) {
            return false;
        }
        if (other.itemCollectionMetrics() == null ^ this.itemCollectionMetrics() == null) {
            return false;
        }
        if (other.itemCollectionMetrics() != null && !other.itemCollectionMetrics().equals(this.itemCollectionMetrics())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        return other.consumedCapacity() == null || other.consumedCapacity().equals(this.consumedCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.unprocessedItems() != null) {
            sb.append("UnprocessedItems: ").append(this.unprocessedItems()).append(",");
        }
        if (this.itemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: ").append(this.itemCollectionMetrics()).append(",");
        }
        if (this.consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.consumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, List<WriteRequest>> unprocessedItems;
        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
        private List<ConsumedCapacity> consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemResponse model) {
            this.setUnprocessedItems(model.unprocessedItems);
            this.setItemCollectionMetrics(model.itemCollectionMetrics);
            this.setConsumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getUnprocessedItems() {
            return this.unprocessedItems;
        }

        @Override
        public final Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
            return this;
        }

        public final void setUnprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
        }

        public final Map<String, ? extends Collection<ItemCollectionMetrics>> getItemCollectionMetrics() {
            return this.itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
        }

        public final Collection<ConsumedCapacity> getConsumedCapacity() {
            return this.consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            if (this.consumedCapacity == null) {
                this.consumedCapacity = new ArrayList<ConsumedCapacity>(consumedCapacity.length);
            }
            for (ConsumedCapacity e : consumedCapacity) {
                this.consumedCapacity.add(e);
            }
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
        }

        @SafeVarargs
        public final void setConsumedCapacity(ConsumedCapacity ... consumedCapacity) {
            if (this.consumedCapacity == null) {
                this.consumedCapacity = new ArrayList<ConsumedCapacity>(consumedCapacity.length);
            }
            for (ConsumedCapacity e : consumedCapacity) {
                this.consumedCapacity.add(e);
            }
        }

        public BatchWriteItemResponse build() {
            return new BatchWriteItemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteItemResponse> {
        public Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> var1);

        public Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);
    }
}

