/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.LowLevelResultListener;
import software.amazon.awssdk.services.dynamodb.document.internal.PageBasedCollection;
import software.amazon.awssdk.services.dynamodb.document.internal.PageIterable;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;

public abstract class ItemCollection<R>
extends PageBasedCollection<Item, R> {
    private int accumulatedItemCount;
    private int accumulatedScannedCount;
    private ConsumedCapacity accumulatedConsumedCapacity;

    protected final void accumulateStats(ConsumedCapacity consumedCapacity, Integer count, Integer scannedCount) {
        if (consumedCapacity != null) {
            if (this.accumulatedConsumedCapacity == null) {
                ConsumedCapacity.Builder cloneBuilder = ConsumedCapacity.builder();
                cloneBuilder.capacityUnits(consumedCapacity.capacityUnits());
                cloneBuilder.globalSecondaryIndexes(this.clone(consumedCapacity.globalSecondaryIndexes()));
                cloneBuilder.localSecondaryIndexes(this.clone(consumedCapacity.localSecondaryIndexes()));
                cloneBuilder.table(this.clone(consumedCapacity.table()));
                cloneBuilder.tableName(consumedCapacity.tableName());
                this.accumulatedConsumedCapacity = (ConsumedCapacity)cloneBuilder.build();
            } else {
                Double capunit = this.accumulatedConsumedCapacity.capacityUnits();
                Double delta = consumedCapacity.capacityUnits();
                this.accumulatedConsumedCapacity = capunit == null ? (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().capacityUnits(delta).build() : (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().capacityUnits(capunit + (delta == null ? 0.0 : delta)).build();
                Map<String, Capacity> gsi = this.accumulatedConsumedCapacity.globalSecondaryIndexes();
                this.accumulatedConsumedCapacity = gsi == null ? (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().globalSecondaryIndexes(this.clone(consumedCapacity.globalSecondaryIndexes())).build() : (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().globalSecondaryIndexes(this.add(consumedCapacity.globalSecondaryIndexes(), this.accumulatedConsumedCapacity.globalSecondaryIndexes())).build();
                Map<String, Capacity> lsi = this.accumulatedConsumedCapacity.localSecondaryIndexes();
                this.accumulatedConsumedCapacity = lsi == null ? (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().localSecondaryIndexes(this.clone(consumedCapacity.localSecondaryIndexes())).build() : (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().localSecondaryIndexes(this.add(consumedCapacity.localSecondaryIndexes(), this.accumulatedConsumedCapacity.localSecondaryIndexes())).build();
                Capacity tableCapacity = this.accumulatedConsumedCapacity.table();
                this.accumulatedConsumedCapacity = tableCapacity == null ? (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().table(this.clone(consumedCapacity.table())).build() : (ConsumedCapacity)this.accumulatedConsumedCapacity.toBuilder().table(this.add(consumedCapacity.table(), this.accumulatedConsumedCapacity.table())).build();
            }
        }
        if (count != null) {
            this.accumulatedItemCount += count.intValue();
        }
        if (scannedCount != null) {
            this.accumulatedScannedCount += scannedCount.intValue();
        }
    }

    private Map<String, Capacity> add(Map<String, Capacity> from, Map<String, Capacity> to) {
        if (to == null) {
            return this.clone(from);
        }
        if (from != null) {
            for (Map.Entry<String, Capacity> entryFrom : from.entrySet()) {
                String key = entryFrom.getKey();
                Capacity tocap = to.get(key);
                Capacity fromcap = entryFrom.getValue();
                if (tocap == null) {
                    to.put(key, this.clone(fromcap));
                    continue;
                }
                to.put(key, (Capacity)Capacity.builder().capacityUnits(this.doubleOf(tocap) + this.doubleOf(fromcap)).build());
            }
        }
        return to;
    }

    private Capacity add(Capacity from, Capacity to) {
        return (Capacity)Capacity.builder().capacityUnits(this.doubleOf(from) + this.doubleOf(to)).build();
    }

    private Map<String, Capacity> clone(Map<String, Capacity> capacityMap) {
        if (capacityMap == null) {
            return null;
        }
        HashMap<String, Capacity> clone = new HashMap<String, Capacity>(capacityMap.size());
        for (Map.Entry<String, Capacity> e : capacityMap.entrySet()) {
            clone.put(e.getKey(), this.clone(e.getValue()));
        }
        return clone;
    }

    private Capacity clone(Capacity capacity) {
        return capacity == null ? null : (Capacity)Capacity.builder().capacityUnits(capacity.capacityUnits()).build();
    }

    private double doubleOf(Capacity cap) {
        if (cap == null) {
            return 0.0;
        }
        Double val = cap.capacityUnits();
        return val == null ? 0.0 : val;
    }

    @Deprecated
    public int getTotalCount() {
        return this.getAccumulatedItemCount();
    }

    public int getAccumulatedItemCount() {
        return this.accumulatedItemCount;
    }

    @Deprecated
    public int getTotalScannedCount() {
        return this.getAccumulatedScannedCount();
    }

    public int getAccumulatedScannedCount() {
        return this.accumulatedScannedCount;
    }

    @Deprecated
    public ConsumedCapacity getTotalConsumedCapacity() {
        return this.getAccumulatedConsumedCapacity();
    }

    public ConsumedCapacity getAccumulatedConsumedCapacity() {
        return this.accumulatedConsumedCapacity;
    }

    @Override
    public PageIterable<Item, R> pages() {
        return super.pages();
    }

    @Override
    public abstract Integer getMaxResultSize();

    @Override
    public R getLastLowLevelResult() {
        return super.getLastLowLevelResult();
    }

    @Override
    public LowLevelResultListener<R> registerLowLevelResultListener(LowLevelResultListener<R> listener) {
        return super.registerLowLevelResultListener(listener);
    }
}

