/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.List;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedList;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class PaginatedQueryList<T>
extends PaginatedList<T> {
    private QueryRequest queryRequest;
    private final DynamoDbMapperConfig config;
    private QueryResponse queryResult;

    public PaginatedQueryList(DynamoDbMapper mapper, Class<T> clazz, DynamoDBClient dynamo, QueryRequest queryRequest, QueryResponse queryResult, DynamoDbMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy, DynamoDbMapperConfig config) {
        super(mapper, clazz, dynamo, paginationLoadingStrategy);
        this.queryRequest = queryRequest;
        this.queryResult = queryResult;
        this.config = config;
        this.allResults.addAll(mapper.marshallIntoObjects(mapper.toParameters(queryResult.items(), clazz, queryRequest.tableName(), config)));
        if (paginationLoadingStrategy == DynamoDbMapperConfig.PaginationLoadingStrategy.EAGER_LOADING) {
            this.loadAllResults();
        }
    }

    @Override
    protected synchronized boolean atEndOfResults() {
        return this.queryResult.lastEvaluatedKey() == null;
    }

    @Override
    protected synchronized List<T> fetchNextPage() {
        this.queryRequest = (QueryRequest)((Object)this.queryRequest.toBuilder().exclusiveStartKey(this.queryResult.lastEvaluatedKey()).build());
        this.queryResult = this.dynamo.query(DynamoDbMapper.applyUserAgent(this.queryRequest));
        return this.mapper.marshallIntoObjects(this.mapper.toParameters(this.queryResult.items(), this.clazz, this.queryRequest.tableName(), this.config));
    }
}

