/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbDeleteExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperTableModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbQueryExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbSaveExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbScanExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.KeyPair;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedParallelScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedQueryList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.QueryResultPage;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3ClientCache;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3Link;
import software.amazon.awssdk.services.dynamodb.datamodeling.ScanResultPage;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;

public interface IDynamoDbMapper {
    public <T> DynamoDbMapperTableModel<T> getTableModel(Class<T> var1);

    public <T> DynamoDbMapperTableModel<T> getTableModel(Class<T> var1, DynamoDbMapperConfig var2);

    public <T> T load(Class<T> var1, Object var2, DynamoDbMapperConfig var3);

    public <T> T load(Class<T> var1, Object var2);

    public <T> T load(Class<T> var1, Object var2, Object var3);

    public <T> T load(T var1);

    public <T> T load(T var1, DynamoDbMapperConfig var2);

    public <T> T load(Class<T> var1, Object var2, Object var3, DynamoDbMapperConfig var4);

    public <T> T marshallIntoObject(Class<T> var1, Map<String, AttributeValue> var2);

    public <T> List<T> marshallIntoObjects(Class<T> var1, List<Map<String, AttributeValue>> var2);

    public <T> void save(T var1);

    public <T> void save(T var1, DynamoDbSaveExpression var2);

    public <T> void save(T var1, DynamoDbMapperConfig var2);

    public <T> void save(T var1, DynamoDbSaveExpression var2, DynamoDbMapperConfig var3);

    public void delete(Object var1);

    public void delete(Object var1, DynamoDbDeleteExpression var2);

    public void delete(Object var1, DynamoDbMapperConfig var2);

    public <T> void delete(T var1, DynamoDbDeleteExpression var2, DynamoDbMapperConfig var3);

    public List<DynamoDbMapper.FailedBatch> batchDelete(Iterable<? extends Object> var1);

    public List<DynamoDbMapper.FailedBatch> batchDelete(Object ... var1);

    public List<DynamoDbMapper.FailedBatch> batchSave(Iterable<? extends Object> var1);

    public List<DynamoDbMapper.FailedBatch> batchSave(Object ... var1);

    public List<DynamoDbMapper.FailedBatch> batchWrite(Iterable<? extends Object> var1, Iterable<? extends Object> var2);

    public List<DynamoDbMapper.FailedBatch> batchWrite(Iterable<? extends Object> var1, Iterable<? extends Object> var2, DynamoDbMapperConfig var3);

    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> var1);

    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> var1, DynamoDbMapperConfig var2);

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> var1);

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> var1, DynamoDbMapperConfig var2);

    public <T> PaginatedScanList<T> scan(Class<T> var1, DynamoDbScanExpression var2);

    public <T> PaginatedScanList<T> scan(Class<T> var1, DynamoDbScanExpression var2, DynamoDbMapperConfig var3);

    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> var1, DynamoDbScanExpression var2, int var3);

    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> var1, DynamoDbScanExpression var2, int var3, DynamoDbMapperConfig var4);

    public <T> ScanResultPage<T> scanPage(Class<T> var1, DynamoDbScanExpression var2, DynamoDbMapperConfig var3);

    public <T> ScanResultPage<T> scanPage(Class<T> var1, DynamoDbScanExpression var2);

    public <T> PaginatedQueryList<T> query(Class<T> var1, DynamoDbQueryExpression<T> var2);

    public <T> PaginatedQueryList<T> query(Class<T> var1, DynamoDbQueryExpression<T> var2, DynamoDbMapperConfig var3);

    public <T> QueryResultPage<T> queryPage(Class<T> var1, DynamoDbQueryExpression<T> var2);

    public <T> QueryResultPage<T> queryPage(Class<T> var1, DynamoDbQueryExpression<T> var2, DynamoDbMapperConfig var3);

    public int count(Class<?> var1, DynamoDbScanExpression var2);

    public int count(Class<?> var1, DynamoDbScanExpression var2, DynamoDbMapperConfig var3);

    public <T> int count(Class<T> var1, DynamoDbQueryExpression<T> var2);

    public <T> int count(Class<T> var1, DynamoDbQueryExpression<T> var2, DynamoDbMapperConfig var3);

    public S3ClientCache s3ClientCache();

    public S3Link createS3Link(String var1, String var2);

    public S3Link createS3Link(Region var1, String var2, String var3);

    public S3Link createS3Link(String var1, String var2, String var3);

    public CreateTableRequest generateCreateTableRequest(Class<?> var1);

    public DeleteTableRequest generateDeleteTableRequest(Class<?> var1);
}

