/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.ReadBatch;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemIterable;

@SdkPublicApi
public class BatchGetItem
implements DatabaseOperation<BatchGetItemRequest, BatchGetItemIterable, Iterable<ResultsPage>> {
    private final Collection<ReadBatch> readBatches;

    private BatchGetItem(Collection<ReadBatch> readBatches) {
        this.readBatches = readBatches;
    }

    public static BatchGetItem of(Collection<ReadBatch> readBatches) {
        return new BatchGetItem(readBatches);
    }

    public static BatchGetItem of(ReadBatch ... readBatches) {
        return new BatchGetItem(Arrays.asList(readBatches));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().readBatches(this.readBatches);
    }

    @Override
    public BatchGetItemRequest generateRequest(MapperExtension mapperExtension) {
        HashMap requestItems = new HashMap();
        this.readBatches.forEach(readBatch -> readBatch.addReadRequestsToMap(requestItems));
        return (BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(Collections.unmodifiableMap(requestItems)).build();
    }

    @Override
    public Iterable<ResultsPage> transformResponse(BatchGetItemIterable response, MapperExtension mapperExtension) {
        return TransformIterable.of(response, (T batchGetItemResponse) -> new ResultsPage((BatchGetItemResponse)batchGetItemResponse, mapperExtension));
    }

    @Override
    public Function<BatchGetItemRequest, BatchGetItemIterable> getServiceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).batchGetItemPaginator(arg_0);
    }

    public Collection<ReadBatch> getReadBatches() {
        return this.readBatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchGetItem that = (BatchGetItem)o;
        return this.readBatches != null ? this.readBatches.equals(that.readBatches) : that.readBatches == null;
    }

    public int hashCode() {
        return this.readBatches != null ? this.readBatches.hashCode() : 0;
    }

    public static class ResultsPage {
        private final BatchGetItemResponse batchGetItemResponse;
        private final MapperExtension mapperExtension;

        private ResultsPage(BatchGetItemResponse batchGetItemResponse, MapperExtension mapperExtension) {
            this.batchGetItemResponse = batchGetItemResponse;
            this.mapperExtension = mapperExtension;
        }

        public <T> List<T> getResultsForTable(MappedTable<T> mappedTable) {
            List results = this.batchGetItemResponse.responses().getOrDefault(mappedTable.getOperationContext().getTableName(), Collections.emptyList());
            return results.stream().map(itemMap -> Utils.readAndTransformSingleItem(itemMap, mappedTable.getTableSchema(), mappedTable.getOperationContext(), this.mapperExtension)).collect(Collectors.toList());
        }
    }

    public static final class Builder {
        private Collection<ReadBatch> readBatches;

        private Builder() {
        }

        public Builder readBatches(Collection<ReadBatch> readBatches) {
            this.readBatches = readBatches;
            return this;
        }

        public BatchGetItem build() {
            return new BatchGetItem(this.readBatches);
        }
    }
}

