/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.ZoneId;
import java.time.zone.ZoneRulesException;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ZoneIdStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class ZoneIdAttributeConverter
implements AttributeConverter<ZoneId> {
    public static final ZoneIdStringConverter STRING_CONVERTER = ZoneIdStringConverter.create();

    public static ZoneIdAttributeConverter create() {
        return new ZoneIdAttributeConverter();
    }

    @Override
    public EnhancedType<ZoneId> type() {
        return EnhancedType.of(ZoneId.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(ZoneId input) {
        return (AttributeValue)AttributeValue.builder().s(STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public ZoneId transformTo(AttributeValue input) {
        try {
            return STRING_CONVERTER.fromString(input.s());
        }
        catch (ZoneRulesException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

