/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.extensions;

import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.utility.NestedRecordUtils;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class AutoGeneratedTimestampRecordExtension
implements DynamoDbEnhancedClientExtension {
    private static final String CUSTOM_METADATA_KEY = "AutoGeneratedTimestampExtension:AutoGeneratedTimestampAttribute";
    private static final AutoGeneratedTimestampAttribute AUTO_GENERATED_TIMESTAMP_ATTRIBUTE = new AutoGeneratedTimestampAttribute();
    private final Clock clock;

    private AutoGeneratedTimestampRecordExtension() {
        this.clock = Clock.systemUTC();
    }

    private AutoGeneratedTimestampRecordExtension(Builder builder) {
        this.clock = builder.baseClock == null ? Clock.systemUTC() : builder.baseClock;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AutoGeneratedTimestampRecordExtension.builder().baseClock(this.clock);
    }

    public static AutoGeneratedTimestampRecordExtension create() {
        return new AutoGeneratedTimestampRecordExtension();
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(context.items());
        HashMap updatedItems = new HashMap();
        Instant currentInstant = this.clock.instant();
        itemToTransform.forEach((key, value) -> {
            if (value.hasM() && value.m() != null) {
                Optional<TableSchema<?>> nestedSchema = EnhancedClientUtils.getNestedSchema(context.tableSchema(), key);
                if (nestedSchema.isPresent()) {
                    Map<String, AttributeValue> processed = this.processNestedObject(value.m(), nestedSchema.get(), currentInstant);
                    updatedItems.put(key, (AttributeValue)AttributeValue.builder().m(processed).build());
                }
            } else if (value.hasL() && !value.l().isEmpty() && ((AttributeValue)value.l().get(0)).hasM()) {
                TableSchema<?> elementListSchema = NestedRecordUtils.getTableSchemaForListElement(context.tableSchema(), key);
                List updatedList = value.l().stream().map(listItem -> listItem.hasM() ? (AttributeValue)AttributeValue.builder().m(this.processNestedObject(listItem.m(), elementListSchema, currentInstant)).build() : listItem).collect(Collectors.toList());
                updatedItems.put(key, (AttributeValue)AttributeValue.builder().l(updatedList).build());
            }
        });
        Map<String, TableSchema<?>> stringTableSchemaMap = NestedRecordUtils.resolveSchemasPerPath(itemToTransform, context.tableSchema());
        stringTableSchemaMap.forEach((path, schema) -> {
            Collection customMetadataObject = schema.tableMetadata().customMetadataObject(CUSTOM_METADATA_KEY, Collection.class).orElse(null);
            if (customMetadataObject != null) {
                customMetadataObject.forEach(key -> this.insertTimestampInItemToTransform(updatedItems, NestedRecordUtils.reconstructCompositeKey(path, key), schema.converterForAttribute(key), currentInstant));
            }
        });
        if (updatedItems.isEmpty()) {
            return WriteModification.builder().build();
        }
        itemToTransform.putAll(updatedItems);
        return WriteModification.builder().transformedItem(Collections.unmodifiableMap(itemToTransform)).build();
    }

    private Map<String, AttributeValue> processNestedObject(Map<String, AttributeValue> nestedMap, TableSchema<?> nestedSchema, Instant currentInstant) {
        HashMap<String, AttributeValue> updatedNestedMap = new HashMap<String, AttributeValue>(nestedMap);
        Collection customMetadataObject = nestedSchema.tableMetadata().customMetadataObject(CUSTOM_METADATA_KEY, Collection.class).orElse(null);
        if (customMetadataObject != null) {
            customMetadataObject.forEach(key -> this.insertTimestampInItemToTransform(updatedNestedMap, String.valueOf(key), nestedSchema.converterForAttribute(key), currentInstant));
        }
        nestedMap.forEach((nestedKey, nestedValue) -> {
            if (nestedValue.hasM()) {
                Optional<TableSchema<?>> childSchemaOptional = EnhancedClientUtils.getNestedSchema(nestedSchema, nestedKey);
                TableSchema<?> schemaToUse = childSchemaOptional.isPresent() ? childSchemaOptional.get() : nestedSchema;
                updatedNestedMap.put((String)nestedKey, (AttributeValue)AttributeValue.builder().m(this.processNestedObject(nestedValue.m(), schemaToUse, currentInstant)).build());
            } else if (nestedValue.hasL() && !nestedValue.l().isEmpty() && ((AttributeValue)nestedValue.l().get(0)).hasM()) {
                try {
                    TableSchema<?> listElementSchema = TableSchema.fromClass(Class.forName(nestedSchema.converterForAttribute(nestedKey).type().rawClassParameters().get(0).rawClass().getName()));
                    List updatedList = nestedValue.l().stream().map(listItem -> listItem.hasM() ? (AttributeValue)AttributeValue.builder().m(this.processNestedObject(listItem.m(), listElementSchema, currentInstant)).build() : listItem).collect(Collectors.toList());
                    updatedNestedMap.put((String)nestedKey, (AttributeValue)AttributeValue.builder().l(updatedList).build());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Class not found for field name: " + nestedKey, e);
                }
            }
        });
        return updatedNestedMap;
    }

    private void insertTimestampInItemToTransform(Map<String, AttributeValue> itemToTransform, String key, AttributeConverter converter, Instant instant) {
        itemToTransform.put(key, converter.transformFrom(instant));
    }

    private static class AutoGeneratedTimestampAttribute
    implements StaticAttributeTag {
        private AutoGeneratedTimestampAttribute() {
        }

        @Override
        public <R> void validateType(String attributeName, EnhancedType<R> type, AttributeValueType attributeValueType) {
            Validate.notNull(type, (String)"type is null", (Object[])new Object[0]);
            Validate.notNull(type.rawClass(), (String)"rawClass is null", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)attributeValueType), (String)"attributeValueType is null", (Object[])new Object[0]);
            if (!type.rawClass().equals(Instant.class)) {
                throw new IllegalArgumentException(String.format("Attribute '%s' of Class type %s is not a suitable Java Class type to be used as a Auto Generated Timestamp attribute. Only java.time.Instant Class type is supported.", attributeName, type.rawClass()));
            }
        }

        @Override
        public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
            return metadata -> metadata.addCustomMetadataObject(AutoGeneratedTimestampRecordExtension.CUSTOM_METADATA_KEY, Collections.singleton(attributeName)).markAttributeAsKey(attributeName, attributeValueType);
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private Clock baseClock;

        private Builder() {
        }

        public Builder baseClock(Clock clock) {
            this.baseClock = clock;
            return this;
        }

        public AutoGeneratedTimestampRecordExtension build() {
            return new AutoGeneratedTimestampRecordExtension(this);
        }
    }

    public static final class AttributeTags {
        private AttributeTags() {
        }

        public static StaticAttributeTag autoGeneratedTimestampAttribute() {
            return AUTO_GENERATED_TIMESTAMP_ATTRIBUTE;
        }
    }
}

