/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkPublicApi
@ThreadSafe
public final class TransactWriteItemsEnhancedResponse {
    private final List<ConsumedCapacity> consumedCapacity;
    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

    private TransactWriteItemsEnhancedResponse(Builder builder) {
        this.consumedCapacity = builder.consumedCapacity == null ? null : Collections.unmodifiableList(builder.consumedCapacity);
        this.itemCollectionMetrics = builder.itemCollectionMetrics == null ? null : CollectionUtils.deepUnmodifiableMap((Map)builder.itemCollectionMetrics);
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactWriteItemsEnhancedResponse that = (TransactWriteItemsEnhancedResponse)o;
        return Objects.equals(this.consumedCapacity, that.consumedCapacity) && Objects.equals(this.itemCollectionMetrics, that.itemCollectionMetrics);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.consumedCapacity);
        result = 31 * result + Objects.hashCode(this.itemCollectionMetrics);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private List<ConsumedCapacity> consumedCapacity;
        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

        public Builder consumedCapacity(List<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = consumedCapacity == null ? null : new ArrayList<ConsumedCapacity>(consumedCapacity);
            return this;
        }

        public Builder itemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics == null ? null : CollectionUtils.deepCopyMap(itemCollectionMetrics);
            return this;
        }

        public TransactWriteItemsEnhancedResponse build() {
            return new TransactWriteItemsEnhancedResponse(this);
        }
    }
}

