/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
@ThreadSafe
public final class BatchWriteResult {
    private final Map<String, List<WriteRequest>> unprocessedRequests;
    private final List<ConsumedCapacity> consumedCapacity;
    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

    private BatchWriteResult(Builder builder) {
        this.unprocessedRequests = Collections.unmodifiableMap(builder.unprocessedRequests);
        this.consumedCapacity = Collections.unmodifiableList(builder.consumedCapacity);
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> List<T> unprocessedPutItemsForTable(MappedTableResource<T> mappedTable) {
        List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return writeRequests.stream().filter(writeRequest -> writeRequest.putRequest() != null).map(WriteRequest::putRequest).map(PutRequest::item).map(item -> EnhancedClientUtils.readAndTransformSingleItem(item, mappedTable.tableSchema(), DefaultOperationContext.create(mappedTable.tableName()), mappedTable.mapperExtension())).collect(Collectors.toList());
    }

    public List<Key> unprocessedDeleteItemsForTable(MappedTableResource<?> mappedTable) {
        List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return writeRequests.stream().filter(writeRequest -> writeRequest.deleteRequest() != null).map(WriteRequest::deleteRequest).map(DeleteRequest::key).map(itemMap -> EnhancedClientUtils.createKeyFromMap(itemMap, mappedTable.tableSchema(), TableMetadata.primaryIndexName())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchWriteResult result = (BatchWriteResult)o;
        return Objects.equals(this.unprocessedRequests, result.unprocessedRequests) && Objects.equals(this.consumedCapacity, result.consumedCapacity) && Objects.equals(this.itemCollectionMetrics, result.itemCollectionMetrics);
    }

    public int hashCode() {
        int result = this.unprocessedRequests != null ? this.unprocessedRequests.hashCode() : 0;
        result = 31 * result + (this.consumedCapacity != null ? this.consumedCapacity.hashCode() : 0);
        result = 31 * result + (this.itemCollectionMetrics != null ? this.itemCollectionMetrics.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private Map<String, List<WriteRequest>> unprocessedRequests;
        private List<ConsumedCapacity> consumedCapacity;
        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

        private Builder() {
        }

        public Builder consumedCapacity(List<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public Builder itemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
            return this;
        }

        public Builder unprocessedRequests(Map<String, List<WriteRequest>> unprocessedRequests) {
            this.unprocessedRequests = unprocessedRequests.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList((List)entry.getValue())));
            return this;
        }

        public BatchWriteResult build() {
            return new BatchWriteResult(this);
        }
    }
}

