/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

@SdkPublicApi
@ThreadSafe
public final class BatchGetResultPage {
    private final BatchGetItemResponse batchGetItemResponse;
    private final DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension;

    private BatchGetResultPage(Builder builder) {
        this.batchGetItemResponse = builder.batchGetItemResponse;
        this.dynamoDbEnhancedClientExtension = builder.dynamoDbEnhancedClientExtension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> List<T> resultsForTable(MappedTableResource<T> mappedTable) {
        List results = this.batchGetItemResponse.responses().getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return results.stream().map(itemMap -> EnhancedClientUtils.readAndTransformSingleItem(itemMap, mappedTable.tableSchema(), DefaultOperationContext.create(mappedTable.tableName()), this.dynamoDbEnhancedClientExtension)).collect(Collectors.toList());
    }

    public List<Key> unprocessedKeysForTable(MappedTableResource<?> mappedTable) {
        KeysAndAttributes keysAndAttributes = (KeysAndAttributes)this.batchGetItemResponse.unprocessedKeys().get(mappedTable.tableName());
        if (keysAndAttributes == null) {
            return Collections.emptyList();
        }
        String partitionKey = mappedTable.tableSchema().tableMetadata().primaryPartitionKey();
        Optional<String> sortKey = mappedTable.tableSchema().tableMetadata().primarySortKey();
        return keysAndAttributes.keys().stream().map(keyMap -> {
            AttributeValue partitionValue = (AttributeValue)keyMap.get(partitionKey);
            AttributeValue sortValue = sortKey.map(keyMap::get).orElse(null);
            return Key.builder().partitionValue(partitionValue).sortValue(sortValue).build();
        }).collect(Collectors.toList());
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.batchGetItemResponse.consumedCapacity();
    }

    @NotThreadSafe
    public static final class Builder {
        private BatchGetItemResponse batchGetItemResponse;
        private DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension;

        private Builder() {
        }

        public Builder batchGetItemResponse(BatchGetItemResponse batchGetItemResponse) {
            this.batchGetItemResponse = batchGetItemResponse;
            return this;
        }

        public Builder mapperExtension(DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
            this.dynamoDbEnhancedClientExtension = dynamoDbEnhancedClientExtension;
            return this;
        }

        public BatchGetResultPage build() {
            return new BatchGetResultPage(this);
        }
    }
}

