/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.ProjectionExpression;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PaginatedIndexOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PaginatedTableOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.Page;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

@SdkInternalApi
public class QueryOperation<T>
implements PaginatedTableOperation<T, QueryRequest, QueryResponse>,
PaginatedIndexOperation<T, QueryRequest, QueryResponse> {
    private final QueryEnhancedRequest request;

    private QueryOperation(QueryEnhancedRequest request) {
        this.request = request;
    }

    public static <T> QueryOperation<T> create(QueryEnhancedRequest request) {
        return new QueryOperation<T>(request);
    }

    @Override
    public OperationName operationName() {
        return OperationName.QUERY;
    }

    @Override
    public QueryRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        Expression queryExpression = this.request.queryConditional().expression(tableSchema, operationContext.indexName());
        Map<String, AttributeValue> expressionValues = queryExpression.expressionValues();
        Map<String, String> expressionNames = queryExpression.expressionNames();
        if (this.request.filterExpression() != null) {
            expressionValues = Expression.joinValues(expressionValues, this.request.filterExpression().expressionValues());
            expressionNames = Expression.joinNames(expressionNames, this.request.filterExpression().expressionNames());
        }
        String projectionExpressionAsString = null;
        if (this.request.attributesToProject() != null) {
            ProjectionExpression attributesToProject = ProjectionExpression.create(this.request.nestedAttributesToProject());
            projectionExpressionAsString = attributesToProject.projectionExpressionAsString().orElse(null);
            expressionNames = Expression.joinNames(expressionNames, attributesToProject.expressionAttributeNames());
        }
        QueryRequest.Builder queryRequest = QueryRequest.builder().tableName(operationContext.tableName()).keyConditionExpression(queryExpression.expression()).expressionAttributeValues(expressionValues).expressionAttributeNames(expressionNames).scanIndexForward(this.request.scanIndexForward()).limit(this.request.limit()).exclusiveStartKey(this.request.exclusiveStartKey()).consistentRead(this.request.consistentRead()).projectionExpression(projectionExpressionAsString);
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            queryRequest = queryRequest.indexName(operationContext.indexName());
        }
        if (this.request.filterExpression() != null) {
            queryRequest = queryRequest.filterExpression(this.request.filterExpression().expression());
        }
        return (QueryRequest)queryRequest.build();
    }

    @Override
    public Function<QueryRequest, SdkIterable<QueryResponse>> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).queryPaginator(arg_0);
    }

    @Override
    public Function<QueryRequest, SdkPublisher<QueryResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).queryPaginator(arg_0);
    }

    @Override
    public Page<T> transformResponse(QueryResponse response, TableSchema<T> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
        return EnhancedClientUtils.readAndTransformPaginatedItems(response, tableSchema, context, dynamoDbEnhancedClientExtension, QueryResponse::items, QueryResponse::lastEvaluatedKey);
    }
}

