/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.BatchableWriteOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DeleteItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PutItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
@ThreadSafe
public final class WriteBatch {
    private final String tableName;
    private final List<WriteRequest> writeRequests;

    private WriteBatch(BuilderImpl<?> builder) {
        this.tableName = ((BuilderImpl)builder).mappedTableResource != null ? ((BuilderImpl)builder).mappedTableResource.tableName() : null;
        this.writeRequests = EnhancedClientUtils.getItemsFromSupplier(((BuilderImpl)builder).itemSupplierList);
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new BuilderImpl(itemClass);
    }

    public String tableName() {
        return this.tableName;
    }

    public Collection<WriteRequest> writeRequests() {
        return this.writeRequests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteBatch that = (WriteBatch)o;
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        return this.writeRequests != null ? this.writeRequests.equals(that.writeRequests) : that.writeRequests == null;
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.writeRequests != null ? this.writeRequests.hashCode() : 0);
        return result;
    }

    private static final class BuilderImpl<T>
    implements Builder<T> {
        private static final String MAPPED_TABLE_RESOURCE_NOT_NULL_MESSAGE = String.format("A mappedTableResource (table) is required when building a %s", WriteBatch.class.getSimpleName());
        private Class<? extends T> itemClass;
        private List<Supplier<WriteRequest>> itemSupplierList = new ArrayList<Supplier<WriteRequest>>();
        private MappedTableResource<T> mappedTableResource;

        private BuilderImpl(Class<? extends T> itemClass) {
            this.itemClass = itemClass;
        }

        @Override
        public Builder<T> mappedTableResource(MappedTableResource<T> mappedTableResource) {
            this.mappedTableResource = mappedTableResource;
            return this;
        }

        @Override
        public Builder<T> addDeleteItem(DeleteItemEnhancedRequest request) {
            Objects.requireNonNull(this.mappedTableResource, MAPPED_TABLE_RESOURCE_NOT_NULL_MESSAGE);
            this.itemSupplierList.add(() -> this.generateWriteRequest(() -> this.mappedTableResource, DeleteItemOperation.create(request)));
            return this;
        }

        @Override
        public Builder<T> addDeleteItem(Consumer<DeleteItemEnhancedRequest.Builder> requestConsumer) {
            DeleteItemEnhancedRequest.Builder builder = DeleteItemEnhancedRequest.builder();
            requestConsumer.accept(builder);
            return this.addDeleteItem((T)builder.build());
        }

        @Override
        public Builder<T> addDeleteItem(Key key) {
            return this.addDeleteItem((T)((Consumer<DeleteItemEnhancedRequest.Builder>)r -> r.key(key)));
        }

        @Override
        public Builder<T> addDeleteItem(T keyItem) {
            Objects.requireNonNull(this.mappedTableResource, MAPPED_TABLE_RESOURCE_NOT_NULL_MESSAGE);
            return this.addDeleteItem((T)this.mappedTableResource.keyFrom(keyItem));
        }

        @Override
        public Builder<T> addPutItem(PutItemEnhancedRequest<T> request) {
            Objects.requireNonNull(this.mappedTableResource, MAPPED_TABLE_RESOURCE_NOT_NULL_MESSAGE);
            this.itemSupplierList.add(() -> this.generateWriteRequest(() -> this.mappedTableResource, PutItemOperation.create(request)));
            return this;
        }

        @Override
        public Builder<T> addPutItem(Consumer<PutItemEnhancedRequest.Builder<T>> requestConsumer) {
            PutItemEnhancedRequest.Builder<T> builder = PutItemEnhancedRequest.builder(this.itemClass);
            requestConsumer.accept(builder);
            return this.addPutItem((T)builder.build());
        }

        @Override
        public Builder<T> addPutItem(T item) {
            return this.addPutItem((T)((Consumer<PutItemEnhancedRequest.Builder>)r -> r.item(item)));
        }

        @Override
        public WriteBatch build() {
            return new WriteBatch(this);
        }

        private WriteRequest generateWriteRequest(Supplier<MappedTableResource<T>> mappedTableResourceSupplier, BatchableWriteOperation<T> operation) {
            return operation.generateWriteRequest(mappedTableResourceSupplier.get().tableSchema(), DefaultOperationContext.create(mappedTableResourceSupplier.get().tableName()), mappedTableResourceSupplier.get().mapperExtension());
        }
    }

    @NotThreadSafe
    public static interface Builder<T> {
        public Builder<T> mappedTableResource(MappedTableResource<T> var1);

        public Builder<T> addDeleteItem(DeleteItemEnhancedRequest var1);

        public Builder<T> addDeleteItem(Consumer<DeleteItemEnhancedRequest.Builder> var1);

        public Builder<T> addDeleteItem(Key var1);

        public Builder<T> addDeleteItem(T var1);

        public Builder<T> addPutItem(PutItemEnhancedRequest<T> var1);

        public Builder<T> addPutItem(Consumer<PutItemEnhancedRequest.Builder<T>> var1);

        public Builder<T> addPutItem(T var1);

        public WriteBatch build();
    }
}

