/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactableWriteOperation;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;

@SdkPublicApi
public final class ConditionCheck<T>
implements TransactableWriteOperation<T> {
    private final Key key;
    private final Expression conditionExpression;
    private final String returnValuesOnConditionCheckFailure;

    private ConditionCheck(Builder builder) {
        this.key = builder.key;
        this.conditionExpression = builder.conditionExpression;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().key(this.key).conditionExpression(this.conditionExpression).returnValuesOnConditionCheckFailure(this.returnValuesOnConditionCheckFailure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionCheck that = (ConditionCheck)o;
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.conditionExpression, that.conditionExpression)) {
            return false;
        }
        return Objects.equals(this.returnValuesOnConditionCheckFailure, that.returnValuesOnConditionCheckFailure);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.key);
        result = 31 * result + Objects.hashCode(this.conditionExpression);
        result = 31 * result + Objects.hashCode(this.returnValuesOnConditionCheckFailure);
        return result;
    }

    public Key key() {
        return this.key;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue((String)this.returnValuesOnConditionCheckFailure);
    }

    public String returnValuesOnConditionCheckFailureAsString() {
        return this.returnValuesOnConditionCheckFailure;
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
        software.amazon.awssdk.services.dynamodb.model.ConditionCheck conditionCheck = (software.amazon.awssdk.services.dynamodb.model.ConditionCheck)software.amazon.awssdk.services.dynamodb.model.ConditionCheck.builder().tableName(operationContext.tableName()).key(this.key.keyMap(tableSchema, operationContext.indexName())).conditionExpression(this.conditionExpression.expression()).expressionAttributeNames(this.conditionExpression.expressionNames()).expressionAttributeValues(this.conditionExpression.expressionValues()).returnValuesOnConditionCheckFailure(this.returnValuesOnConditionCheckFailure).build();
        return (TransactWriteItem)TransactWriteItem.builder().conditionCheck(conditionCheck).build();
    }

    public static final class Builder {
        private Key key;
        private Expression conditionExpression;
        private String returnValuesOnConditionCheckFailure;

        private Builder() {
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Consumer<Key.Builder> keyConsumer) {
            Key.Builder builder = Key.builder();
            keyConsumer.accept(builder);
            return this.key(builder.build());
        }

        public Builder conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure == null ? null : returnValuesOnConditionCheckFailure.toString();
            return this;
        }

        public Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        public <T> ConditionCheck<T> build() {
            return new ConditionCheck(this);
        }
    }
}

