/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

@SdkPublicApi
public final class ReadBatch {
    private final String tableName;
    private final KeysAndAttributes keysAndAttributes;

    private ReadBatch(BuilderImpl<?> builder) {
        this.tableName = ((BuilderImpl)builder).mappedTableResource != null ? ((BuilderImpl)builder).mappedTableResource.tableName() : null;
        this.keysAndAttributes = ReadBatch.generateKeysAndAttributes(((BuilderImpl)builder).requests, ((BuilderImpl)builder).mappedTableResource);
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new BuilderImpl();
    }

    public String tableName() {
        return this.tableName;
    }

    public KeysAndAttributes keysAndAttributes() {
        return this.keysAndAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadBatch readBatch = (ReadBatch)o;
        if (this.tableName != null ? !this.tableName.equals(readBatch.tableName) : readBatch.tableName != null) {
            return false;
        }
        return this.keysAndAttributes != null ? this.keysAndAttributes.equals((Object)readBatch.keysAndAttributes) : readBatch.keysAndAttributes == null;
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.keysAndAttributes != null ? this.keysAndAttributes.hashCode() : 0);
        return result;
    }

    private static <T> KeysAndAttributes generateKeysAndAttributes(List<GetItemEnhancedRequest> readRequests, MappedTableResource<T> mappedTableResource) {
        if (readRequests == null || readRequests.isEmpty()) {
            return null;
        }
        Boolean firstRecordConsistentRead = ReadBatch.validateAndGetConsistentRead(readRequests);
        List keys = readRequests.stream().map(GetItemEnhancedRequest::key).map(key -> key.keyMap(mappedTableResource.tableSchema(), TableMetadata.primaryIndexName())).collect(Collectors.toList());
        return (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).consistentRead(firstRecordConsistentRead).build();
    }

    private static Boolean validateAndGetConsistentRead(List<GetItemEnhancedRequest> readRequests) {
        Boolean firstRecordConsistentRead = null;
        boolean isFirstRecord = true;
        for (GetItemEnhancedRequest request : readRequests) {
            if (isFirstRecord) {
                isFirstRecord = false;
                firstRecordConsistentRead = request.consistentRead();
                continue;
            }
            if (ReadBatch.compareNullableBooleans(firstRecordConsistentRead, request.consistentRead())) continue;
            throw new IllegalArgumentException("All batchable read requests for the same table must have the same 'consistentRead' setting.");
        }
        return firstRecordConsistentRead;
    }

    private static boolean compareNullableBooleans(Boolean one, Boolean two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null) {
            return one.equals(two);
        }
        return false;
    }

    private static final class BuilderImpl<T>
    implements Builder<T> {
        private MappedTableResource<T> mappedTableResource;
        private List<GetItemEnhancedRequest> requests = new ArrayList<GetItemEnhancedRequest>();

        private BuilderImpl() {
        }

        @Override
        public Builder<T> mappedTableResource(MappedTableResource<T> mappedTableResource) {
            this.mappedTableResource = mappedTableResource;
            return this;
        }

        @Override
        public Builder<T> addGetItem(GetItemEnhancedRequest request) {
            this.requests.add(request);
            return this;
        }

        @Override
        public Builder<T> addGetItem(Consumer<GetItemEnhancedRequest.Builder> requestConsumer) {
            GetItemEnhancedRequest.Builder builder = GetItemEnhancedRequest.builder();
            requestConsumer.accept(builder);
            return this.addGetItem((T)builder.build());
        }

        @Override
        public Builder<T> addGetItem(Key key) {
            return this.addGetItem((T)((Consumer<GetItemEnhancedRequest.Builder>)r -> r.key(key)));
        }

        @Override
        public Builder<T> addGetItem(T keyItem) {
            return this.addGetItem((T)this.mappedTableResource.keyFrom(keyItem));
        }

        @Override
        public ReadBatch build() {
            return new ReadBatch(this);
        }
    }

    public static interface Builder<T> {
        public Builder<T> mappedTableResource(MappedTableResource<T> var1);

        public Builder<T> addGetItem(GetItemEnhancedRequest var1);

        public Builder<T> addGetItem(Consumer<GetItemEnhancedRequest.Builder> var1);

        public Builder<T> addGetItem(Key var1);

        public Builder<T> addGetItem(T var1);

        public ReadBatch build();
    }
}

