/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;

@SdkInternalApi
public final class ChainConverterProvider
implements AttributeConverterProvider {
    private final List<AttributeConverterProvider> providerChain;

    private ChainConverterProvider(List<AttributeConverterProvider> providers) {
        this.providerChain = new ArrayList<AttributeConverterProvider>(providers);
    }

    public static ChainConverterProvider create(AttributeConverterProvider ... providers) {
        return new ChainConverterProvider(Arrays.asList(providers));
    }

    public static ChainConverterProvider create(List<AttributeConverterProvider> providers) {
        return new ChainConverterProvider(providers);
    }

    public List<AttributeConverterProvider> chainedProviders() {
        return Collections.unmodifiableList(this.providerChain);
    }

    @Override
    public <T> AttributeConverter<T> converterFor(EnhancedType<T> enhancedType) {
        return this.providerChain.stream().filter(provider -> provider.converterFor(enhancedType) != null).map(p -> p.converterFor(enhancedType)).findFirst().orElse(null);
    }
}

