/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;

@SdkInternalApi
public class OperationContext {
    private final String tableName;
    private final String indexName;

    private OperationContext(String tableName, String indexName) {
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public static OperationContext create(String tableName, String indexName) {
        return new OperationContext(tableName, indexName);
    }

    public static OperationContext create(String tableName) {
        return new OperationContext(tableName, TableMetadata.primaryIndexName());
    }

    public String tableName() {
        return this.tableName;
    }

    public String indexName() {
        return this.indexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationContext that = (OperationContext)o;
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        return this.indexName != null ? this.indexName.equals(that.indexName) : that.indexName == null;
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        return result;
    }
}

