/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.concurrent.atomic.AtomicLong;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.AtomicLongStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class AtomicLongAttributeConverter
implements AttributeConverter<AtomicLong> {
    private static final Visitor VISITOR = new Visitor();
    private static final AtomicLongStringConverter STRING_CONVERTER = AtomicLongStringConverter.create();

    private AtomicLongAttributeConverter() {
    }

    @Override
    public EnhancedType<AtomicLong> type() {
        return EnhancedType.of(AtomicLong.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    public static AtomicLongAttributeConverter create() {
        return new AtomicLongAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(AtomicLong input) {
        return EnhancedAttributeValue.fromNumber(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public AtomicLong transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<AtomicLong> {
        private Visitor() {
            super(AtomicLong.class, AtomicLongAttributeConverter.class);
        }

        @Override
        public AtomicLong convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public AtomicLong convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

