/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.extensions;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.extensions.ReadModification;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationContext;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class ChainExtension
implements DynamoDbEnhancedClientExtension {
    private final Deque<DynamoDbEnhancedClientExtension> extensionChain;

    private ChainExtension(List<DynamoDbEnhancedClientExtension> extensions) {
        this.extensionChain = new ArrayDeque<DynamoDbEnhancedClientExtension>(extensions);
    }

    public static ChainExtension create(DynamoDbEnhancedClientExtension ... extensions) {
        return new ChainExtension(Arrays.asList(extensions));
    }

    public static ChainExtension create(List<DynamoDbEnhancedClientExtension> extensions) {
        return new ChainExtension(extensions);
    }

    @Override
    public WriteModification beforeWrite(Map<String, AttributeValue> item, OperationContext operationContext, TableMetadata tableMetadata) {
        AtomicReference transformedItem = new AtomicReference();
        AtomicReference conditionalExpression = new AtomicReference();
        this.extensionChain.forEach(extension -> {
            Map itemToTransform = transformedItem.get() == null ? item : (Map)transformedItem.get();
            WriteModification writeModification = extension.beforeWrite(itemToTransform, operationContext, tableMetadata);
            if (writeModification.transformedItem() != null) {
                transformedItem.set(writeModification.transformedItem());
            }
            if (writeModification.additionalConditionalExpression() != null) {
                if (conditionalExpression.get() == null) {
                    conditionalExpression.set(writeModification.additionalConditionalExpression());
                } else {
                    conditionalExpression.set(Expression.join((Expression)conditionalExpression.get(), writeModification.additionalConditionalExpression(), " AND "));
                }
            }
        });
        return WriteModification.builder().transformedItem((Map)transformedItem.get()).additionalConditionalExpression((Expression)conditionalExpression.get()).build();
    }

    @Override
    public ReadModification afterRead(Map<String, AttributeValue> item, OperationContext operationContext, TableMetadata tableMetadata) {
        AtomicReference transformedItem = new AtomicReference();
        this.extensionChain.descendingIterator().forEachRemaining(extension -> {
            Map itemToTransform = transformedItem.get() == null ? item : (Map)transformedItem.get();
            ReadModification readModification = extension.afterRead(itemToTransform, operationContext, tableMetadata);
            if (readModification.transformedItem() != null) {
                transformedItem.set(readModification.transformedItem());
            }
        });
        return ReadModification.builder().transformedItem((Map)transformedItem.get()).build();
    }
}

