/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class IntegerStringConverter
implements StringConverter<Integer>,
PrimitiveConverter<Integer> {
    private IntegerStringConverter() {
    }

    public static IntegerStringConverter create() {
        return new IntegerStringConverter();
    }

    @Override
    public TypeToken<Integer> type() {
        return TypeToken.of(Integer.class);
    }

    @Override
    public TypeToken<Integer> primitiveType() {
        return TypeToken.of(Integer.TYPE);
    }

    @Override
    public Integer fromString(String string) {
        return Integer.valueOf(string);
    }
}

