/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ZoneOffsetStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class ZoneOffsetAttributeConverter
implements AttributeConverter<ZoneOffset> {
    public static final ZoneOffsetStringConverter STRING_CONVERTER = ZoneOffsetStringConverter.create();

    public static ZoneOffsetAttributeConverter create() {
        return new ZoneOffsetAttributeConverter();
    }

    @Override
    public TypeToken<ZoneOffset> type() {
        return TypeToken.of(ZoneOffset.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(ZoneOffset input) {
        return EnhancedAttributeValue.fromString(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public ZoneOffset transformTo(AttributeValue input) {
        try {
            return EnhancedAttributeValue.fromAttributeValue(input).convert(Visitor.INSTANCE);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class Visitor
    extends TypeConvertingVisitor<ZoneOffset> {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
            super(ZoneOffset.class, ZoneOffsetAttributeConverter.class);
        }

        @Override
        public ZoneOffset convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

