/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class StaticAttributeType<T>
implements AttributeType<T> {
    private final AttributeConverter<T> attributeConverter;
    private final AttributeValueType attributeValueType;

    private StaticAttributeType(AttributeConverter<T> attributeConverter) {
        this.attributeConverter = attributeConverter;
        this.attributeValueType = attributeConverter.attributeValueType();
    }

    public static <T> AttributeType<T> create(AttributeConverter<T> attributeConverter) {
        return new StaticAttributeType<T>(attributeConverter);
    }

    @Override
    public AttributeValue objectToAttributeValue(T object) {
        return this.attributeConverter.transformFrom(object);
    }

    @Override
    public T attributeValueToObject(AttributeValue attributeValue) {
        return this.attributeConverter.transformTo(attributeValue);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return this.attributeValueType;
    }
}

