/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class ByteStringConverter
implements StringConverter<Byte>,
PrimitiveConverter<Byte> {
    private ByteStringConverter() {
    }

    public static ByteStringConverter create() {
        return new ByteStringConverter();
    }

    @Override
    public TypeToken<Byte> type() {
        return TypeToken.of(Byte.class);
    }

    @Override
    public TypeToken<Byte> primitiveType() {
        return TypeToken.of(Byte.TYPE);
    }

    @Override
    public Byte fromString(String string) {
        return Byte.valueOf(string);
    }
}

