/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class EnhancedAttributeValue {
    private final AttributeValueType type;
    private final boolean isNull;
    private final Map<String, EnhancedAttributeValue> mapValue;
    private final String stringValue;
    private final String numberValue;
    private final SdkBytes bytesValue;
    private final Boolean booleanValue;
    private final List<String> setOfStringsValue;
    private final List<String> setOfNumbersValue;
    private final List<SdkBytes> setOfBytesValue;
    private final List<EnhancedAttributeValue> listOfAttributeValuesValue;

    private EnhancedAttributeValue(InternalBuilder builder) {
        this.type = builder.type;
        this.isNull = builder.isNull;
        this.stringValue = builder.stringValue;
        this.numberValue = builder.numberValue;
        this.bytesValue = builder.bytesValue;
        this.booleanValue = builder.booleanValue;
        this.mapValue = builder.mapValue == null ? null : Collections.unmodifiableMap(new LinkedHashMap(builder.mapValue));
        this.setOfStringsValue = builder.setOfStringsValue == null ? null : Collections.unmodifiableList(new ArrayList(builder.setOfStringsValue));
        this.setOfNumbersValue = builder.setOfNumbersValue == null ? null : Collections.unmodifiableList(new ArrayList(builder.setOfNumbersValue));
        this.setOfBytesValue = builder.setOfBytesValue == null ? null : Collections.unmodifiableList(new ArrayList(builder.setOfBytesValue));
        this.listOfAttributeValuesValue = builder.listOfAttributeValuesValue == null ? null : Collections.unmodifiableList(new ArrayList(builder.listOfAttributeValuesValue));
    }

    public static EnhancedAttributeValue nullValue() {
        return new InternalBuilder().isNull().build();
    }

    public static EnhancedAttributeValue fromMap(Map<String, EnhancedAttributeValue> mapValue) {
        Validate.paramNotNull(mapValue, (String)"mapValue");
        Validate.noNullElements(mapValue.keySet(), (String)"Map must not have null keys.", (Object[])new Object[0]);
        return new InternalBuilder().mapValue(mapValue).build();
    }

    public static EnhancedAttributeValue fromString(String stringValue) {
        Validate.paramNotNull((Object)stringValue, (String)"stringValue");
        return new InternalBuilder().stringValue(stringValue).build();
    }

    public static EnhancedAttributeValue fromNumber(String numberValue) {
        Validate.paramNotNull((Object)numberValue, (String)"numberValue");
        return new InternalBuilder().numberValue(numberValue).build();
    }

    public static EnhancedAttributeValue fromBytes(SdkBytes bytesValue) {
        Validate.paramNotNull((Object)bytesValue, (String)"bytesValue");
        return new InternalBuilder().bytesValue(bytesValue).build();
    }

    public static EnhancedAttributeValue fromBoolean(Boolean booleanValue) {
        Validate.paramNotNull((Object)booleanValue, (String)"booleanValue");
        return new InternalBuilder().booleanValue(booleanValue).build();
    }

    public static EnhancedAttributeValue fromSetOfStrings(String ... setOfStringsValue) {
        Validate.paramNotNull((Object)setOfStringsValue, (String)"setOfStringsValue");
        return EnhancedAttributeValue.fromSetOfStrings(Arrays.asList(setOfStringsValue));
    }

    public static EnhancedAttributeValue fromSetOfStrings(Collection<String> setOfStringsValue) {
        Validate.paramNotNull(setOfStringsValue, (String)"setOfStringsValue");
        Validate.noNullElements(setOfStringsValue, (String)"Set must not have null values.", (Object[])new Object[0]);
        return new InternalBuilder().setOfStringsValue(setOfStringsValue).build();
    }

    public static EnhancedAttributeValue fromSetOfNumbers(String ... setOfNumbersValue) {
        Validate.paramNotNull((Object)setOfNumbersValue, (String)"setOfNumbersValue");
        return EnhancedAttributeValue.fromSetOfNumbers(Arrays.asList(setOfNumbersValue));
    }

    public static EnhancedAttributeValue fromSetOfNumbers(Collection<String> setOfNumbersValue) {
        Validate.paramNotNull(setOfNumbersValue, (String)"setOfNumbersValue");
        Validate.noNullElements(setOfNumbersValue, (String)"Set must not have null values.", (Object[])new Object[0]);
        return new InternalBuilder().setOfNumbersValue(setOfNumbersValue).build();
    }

    public static EnhancedAttributeValue fromSetOfBytes(SdkBytes ... setOfBytesValue) {
        Validate.paramNotNull((Object)setOfBytesValue, (String)"setOfBytesValue");
        return EnhancedAttributeValue.fromSetOfBytes(Arrays.asList(setOfBytesValue));
    }

    public static EnhancedAttributeValue fromSetOfBytes(Collection<SdkBytes> setOfBytesValue) {
        Validate.paramNotNull(setOfBytesValue, (String)"setOfBytesValue");
        Validate.noNullElements(setOfBytesValue, (String)"Set must not have null values.", (Object[])new Object[0]);
        return new InternalBuilder().setOfBytesValue(setOfBytesValue).build();
    }

    public static EnhancedAttributeValue fromListOfAttributeValues(EnhancedAttributeValue ... listOfAttributeValuesValue) {
        Validate.paramNotNull((Object)listOfAttributeValuesValue, (String)"listOfAttributeValuesValue");
        return EnhancedAttributeValue.fromListOfAttributeValues(Arrays.asList(listOfAttributeValuesValue));
    }

    public static EnhancedAttributeValue fromListOfAttributeValues(List<EnhancedAttributeValue> listOfAttributeValuesValue) {
        Validate.paramNotNull(listOfAttributeValuesValue, (String)"listOfAttributeValuesValue");
        Validate.noNullElements(listOfAttributeValuesValue, (String)"List must not have null values.", (Object[])new Object[0]);
        return new InternalBuilder().listOfAttributeValuesValue(listOfAttributeValuesValue).build();
    }

    public static EnhancedAttributeValue flatten(List<EnhancedAttributeValue> listOfAttributeValuesValue) {
        Validate.paramNotNull(listOfAttributeValuesValue, (String)"listOfAttributeValuesValue");
        Validate.noNullElements(listOfAttributeValuesValue, (String)"List must not have null values.", (Object[])new Object[0]);
        AttributeValueType type = listOfAttributeValuesValue.get((int)0).type;
        switch (type) {
            case N: {
                return EnhancedAttributeValue.fromSetOfNumbers(listOfAttributeValuesValue.stream().map(i -> i.numberValue).collect(Collectors.toList()));
            }
            case S: {
                return EnhancedAttributeValue.fromSetOfStrings(listOfAttributeValuesValue.stream().map(i -> i.stringValue).collect(Collectors.toList()));
            }
            case B: {
                return EnhancedAttributeValue.fromSetOfBytes(listOfAttributeValuesValue.stream().map(i -> i.bytesValue).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static EnhancedAttributeValue fromAttributeValueMap(Map<String, AttributeValue> attributeValues) {
        Validate.paramNotNull(attributeValues, (String)"attributeValues");
        LinkedHashMap<String, EnhancedAttributeValue> result = new LinkedHashMap<String, EnhancedAttributeValue>();
        attributeValues.forEach((key, value) -> {
            Validate.notNull((Object)key, (String)"Generated item must not contain null keys.", (Object[])new Object[0]);
            result.put((String)key, EnhancedAttributeValue.fromAttributeValue(value));
        });
        return EnhancedAttributeValue.fromMap(result);
    }

    public static EnhancedAttributeValue fromAttributeValue(AttributeValue attributeValue) {
        Validate.notNull((Object)attributeValue, (String)"Generated attribute value must not contain null values. Use AttributeValue#nul() instead.", (Object[])new Object[0]);
        if (attributeValue.s() != null) {
            return EnhancedAttributeValue.fromString(attributeValue.s());
        }
        if (attributeValue.n() != null) {
            return EnhancedAttributeValue.fromNumber(attributeValue.n());
        }
        if (attributeValue.bool() != null) {
            return EnhancedAttributeValue.fromBoolean(attributeValue.bool());
        }
        if (Boolean.TRUE.equals(attributeValue.nul())) {
            return EnhancedAttributeValue.nullValue();
        }
        if (attributeValue.b() != null) {
            return EnhancedAttributeValue.fromBytes(attributeValue.b());
        }
        if (attributeValue.m() != null && !(attributeValue.m() instanceof SdkAutoConstructMap)) {
            LinkedHashMap<String, EnhancedAttributeValue> map = new LinkedHashMap<String, EnhancedAttributeValue>();
            attributeValue.m().forEach((k, v) -> map.put((String)k, EnhancedAttributeValue.fromAttributeValue(v)));
            return EnhancedAttributeValue.fromMap(map);
        }
        if (attributeValue.l() != null && !(attributeValue.l() instanceof SdkAutoConstructList)) {
            List<EnhancedAttributeValue> list = attributeValue.l().stream().map(EnhancedAttributeValue::fromAttributeValue).collect(Collectors.toList());
            return EnhancedAttributeValue.fromListOfAttributeValues(list);
        }
        if (attributeValue.bs() != null && !(attributeValue.bs() instanceof SdkAutoConstructList)) {
            return EnhancedAttributeValue.fromSetOfBytes(attributeValue.bs());
        }
        if (attributeValue.ss() != null && !(attributeValue.ss() instanceof SdkAutoConstructList)) {
            return EnhancedAttributeValue.fromSetOfStrings(attributeValue.ss());
        }
        if (attributeValue.ns() != null && !(attributeValue.ns() instanceof SdkAutoConstructList)) {
            return EnhancedAttributeValue.fromSetOfNumbers(attributeValue.ns());
        }
        throw new IllegalStateException("Unable to convert attribute value: " + attributeValue);
    }

    public AttributeValueType type() {
        return this.type;
    }

    public <T> T convert(TypeConvertingVisitor<T> convertingVisitor) {
        Validate.paramNotNull(convertingVisitor, (String)"convertingVisitor");
        return convertingVisitor.convert(this);
    }

    public boolean isMap() {
        return this.mapValue != null;
    }

    public boolean isString() {
        return this.stringValue != null;
    }

    public boolean isNumber() {
        return this.numberValue != null;
    }

    public boolean isBytes() {
        return this.bytesValue != null;
    }

    public boolean isBoolean() {
        return this.booleanValue != null;
    }

    public boolean isSetOfStrings() {
        return this.setOfStringsValue != null;
    }

    public boolean isSetOfNumbers() {
        return this.setOfNumbersValue != null;
    }

    public boolean isSetOfBytes() {
        return this.setOfBytesValue != null;
    }

    public boolean isListOfAttributeValues() {
        return this.listOfAttributeValuesValue != null;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public Map<String, EnhancedAttributeValue> asMap() {
        Validate.isTrue((boolean)this.isMap(), (String)"Value is not a map.", (Object[])new Object[0]);
        return this.mapValue;
    }

    public String asString() {
        Validate.isTrue((boolean)this.isString(), (String)"Value is not a string.", (Object[])new Object[0]);
        return this.stringValue;
    }

    public String asNumber() {
        Validate.isTrue((boolean)this.isNumber(), (String)"Value is not a number.", (Object[])new Object[0]);
        return this.numberValue;
    }

    public SdkBytes asBytes() {
        Validate.isTrue((boolean)this.isBytes(), (String)"Value is not bytes.", (Object[])new Object[0]);
        return this.bytesValue;
    }

    public Boolean asBoolean() {
        Validate.isTrue((boolean)this.isBoolean(), (String)"Value is not a boolean.", (Object[])new Object[0]);
        return this.booleanValue;
    }

    public List<String> asSetOfStrings() {
        Validate.isTrue((boolean)this.isSetOfStrings(), (String)"Value is not a list of strings.", (Object[])new Object[0]);
        return this.setOfStringsValue;
    }

    public List<String> asSetOfNumbers() {
        Validate.isTrue((boolean)this.isSetOfNumbers(), (String)"Value is not a list of numbers.", (Object[])new Object[0]);
        return this.setOfNumbersValue;
    }

    public List<SdkBytes> asSetOfBytes() {
        Validate.isTrue((boolean)this.isSetOfBytes(), (String)"Value is not a list of bytes.", (Object[])new Object[0]);
        return this.setOfBytesValue;
    }

    public List<EnhancedAttributeValue> asListOfAttributeValues() {
        Validate.isTrue((boolean)this.isListOfAttributeValues(), (String)"Value is not a list of attribute values.", (Object[])new Object[0]);
        return this.listOfAttributeValuesValue;
    }

    public Map<String, AttributeValue> toAttributeValueMap() {
        Validate.validState((boolean)this.isMap(), (String)"Cannot convert an attribute value of type %s to a generated item. Must be %s.", (Object[])new Object[]{this.type(), AttributeValueType.M});
        AttributeValue generatedAttributeValue = this.toAttributeValue();
        Validate.validState((generatedAttributeValue.m() != null && !(generatedAttributeValue.m() instanceof SdkAutoConstructMap) ? 1 : 0) != 0, (String)"Map EnhancedAttributeValue was not converted into a Map AttributeValue.", (Object[])new Object[0]);
        return generatedAttributeValue.m();
    }

    public AttributeValue toAttributeValue() {
        return this.convert(ToGeneratedAttributeValueVisitor.INSTANCE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnhancedAttributeValue that = (EnhancedAttributeValue)o;
        if (this.isNull != that.isNull) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.mapValue != null ? !this.mapValue.equals(that.mapValue) : that.mapValue != null) {
            return false;
        }
        if (this.stringValue != null ? !this.stringValue.equals(that.stringValue) : that.stringValue != null) {
            return false;
        }
        if (this.numberValue != null ? !this.numberValue.equals(that.numberValue) : that.numberValue != null) {
            return false;
        }
        if (this.bytesValue != null ? !this.bytesValue.equals((Object)that.bytesValue) : that.bytesValue != null) {
            return false;
        }
        if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) {
            return false;
        }
        if (this.setOfStringsValue != null ? !this.setOfStringsValue.equals(that.setOfStringsValue) : that.setOfStringsValue != null) {
            return false;
        }
        if (this.setOfNumbersValue != null ? !this.setOfNumbersValue.equals(that.setOfNumbersValue) : that.setOfNumbersValue != null) {
            return false;
        }
        if (this.setOfBytesValue != null ? !this.setOfBytesValue.equals(that.setOfBytesValue) : that.setOfBytesValue != null) {
            return false;
        }
        return this.listOfAttributeValuesValue != null ? this.listOfAttributeValuesValue.equals(that.listOfAttributeValuesValue) : that.listOfAttributeValuesValue == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.isNull ? 1 : 0);
        result = 31 * result + (this.mapValue != null ? this.mapValue.hashCode() : 0);
        result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
        result = 31 * result + (this.numberValue != null ? this.numberValue.hashCode() : 0);
        result = 31 * result + (this.bytesValue != null ? this.bytesValue.hashCode() : 0);
        result = 31 * result + (this.booleanValue != null ? this.booleanValue.hashCode() : 0);
        result = 31 * result + (this.setOfStringsValue != null ? this.setOfStringsValue.hashCode() : 0);
        result = 31 * result + (this.setOfNumbersValue != null ? this.setOfNumbersValue.hashCode() : 0);
        result = 31 * result + (this.setOfBytesValue != null ? this.setOfBytesValue.hashCode() : 0);
        result = 31 * result + (this.listOfAttributeValuesValue != null ? this.listOfAttributeValuesValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        Object value = this.convert(ToStringVisitor.INSTANCE);
        return ToString.builder((String)"EnhancedAttributeValue").add("type", (Object)this.type).add("value", value).build();
    }

    private static class InternalBuilder {
        private AttributeValueType type;
        private boolean isNull = false;
        private Map<String, EnhancedAttributeValue> mapValue;
        private String stringValue;
        private String numberValue;
        private SdkBytes bytesValue;
        private Boolean booleanValue;
        private Collection<String> setOfStringsValue;
        private Collection<String> setOfNumbersValue;
        private Collection<SdkBytes> setOfBytesValue;
        private Collection<EnhancedAttributeValue> listOfAttributeValuesValue;

        private InternalBuilder() {
        }

        public InternalBuilder isNull() {
            this.type = AttributeValueType.NULL;
            this.isNull = true;
            return this;
        }

        private InternalBuilder mapValue(Map<String, EnhancedAttributeValue> mapValue) {
            this.type = AttributeValueType.M;
            this.mapValue = mapValue;
            return this;
        }

        private InternalBuilder stringValue(String stringValue) {
            this.type = AttributeValueType.S;
            this.stringValue = stringValue;
            return this;
        }

        private InternalBuilder numberValue(String numberValue) {
            this.type = AttributeValueType.N;
            this.numberValue = numberValue;
            return this;
        }

        private InternalBuilder bytesValue(SdkBytes bytesValue) {
            this.type = AttributeValueType.B;
            this.bytesValue = bytesValue;
            return this;
        }

        private InternalBuilder booleanValue(Boolean booleanValue) {
            this.type = AttributeValueType.BOOL;
            this.booleanValue = booleanValue;
            return this;
        }

        private InternalBuilder setOfStringsValue(Collection<String> setOfStringsValue) {
            this.type = AttributeValueType.SS;
            this.setOfStringsValue = setOfStringsValue;
            return this;
        }

        private InternalBuilder setOfNumbersValue(Collection<String> setOfNumbersValue) {
            this.type = AttributeValueType.NS;
            this.setOfNumbersValue = setOfNumbersValue;
            return this;
        }

        private InternalBuilder setOfBytesValue(Collection<SdkBytes> setOfBytesValue) {
            this.type = AttributeValueType.BS;
            this.setOfBytesValue = setOfBytesValue;
            return this;
        }

        private InternalBuilder listOfAttributeValuesValue(Collection<EnhancedAttributeValue> listOfAttributeValuesValue) {
            this.type = AttributeValueType.L;
            this.listOfAttributeValuesValue = listOfAttributeValuesValue;
            return this;
        }

        private EnhancedAttributeValue build() {
            return new EnhancedAttributeValue(this);
        }
    }

    private static class ToStringVisitor
    extends TypeConvertingVisitor<Object> {
        private static final ToStringVisitor INSTANCE = new ToStringVisitor();

        private ToStringVisitor() {
            super(Object.class);
        }

        @Override
        public Object convertNull() {
            return "null";
        }

        @Override
        public Object defaultConvert(AttributeValueType type, Object value) {
            return value;
        }
    }

    private static class ToGeneratedAttributeValueVisitor
    extends TypeConvertingVisitor<AttributeValue> {
        private static final ToGeneratedAttributeValueVisitor INSTANCE = new ToGeneratedAttributeValueVisitor();

        private ToGeneratedAttributeValueVisitor() {
            super(AttributeValue.class);
        }

        @Override
        public AttributeValue convertNull() {
            return (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        }

        @Override
        public AttributeValue convertMap(Map<String, EnhancedAttributeValue> value) {
            LinkedHashMap map = new LinkedHashMap();
            value.forEach((k, v) -> map.put(k, v.toAttributeValue()));
            return (AttributeValue)AttributeValue.builder().m(map).build();
        }

        @Override
        public AttributeValue convertString(String value) {
            return (AttributeValue)AttributeValue.builder().s(value).build();
        }

        @Override
        public AttributeValue convertNumber(String value) {
            return (AttributeValue)AttributeValue.builder().n(value).build();
        }

        @Override
        public AttributeValue convertBytes(SdkBytes value) {
            return (AttributeValue)AttributeValue.builder().b(value).build();
        }

        @Override
        public AttributeValue convertBoolean(Boolean value) {
            return (AttributeValue)AttributeValue.builder().bool(value).build();
        }

        @Override
        public AttributeValue convertSetOfStrings(List<String> value) {
            return (AttributeValue)AttributeValue.builder().ss(value).build();
        }

        @Override
        public AttributeValue convertSetOfNumbers(List<String> value) {
            return (AttributeValue)AttributeValue.builder().ns(value).build();
        }

        @Override
        public AttributeValue convertSetOfBytes(List<SdkBytes> value) {
            return (AttributeValue)AttributeValue.builder().bs(value).build();
        }

        @Override
        public AttributeValue convertListOfAttributeValues(List<EnhancedAttributeValue> value) {
            return (AttributeValue)AttributeValue.builder().l((Collection)value.stream().map(EnhancedAttributeValue::toAttributeValue).collect(Collectors.toList())).build();
        }
    }
}

