/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ByteStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class ByteAttributeConverter
implements AttributeConverter<Byte>,
PrimitiveConverter<Byte> {
    private static final ByteStringConverter STRING_CONVERTER = ByteStringConverter.create();
    private static final Visitor VISITOR = new Visitor();

    private ByteAttributeConverter() {
    }

    public static ByteAttributeConverter create() {
        return new ByteAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(Byte input) {
        return EnhancedAttributeValue.fromNumber(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public Byte transformTo(AttributeValue input) {
        if (input.b() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    @Override
    public TypeToken<Byte> type() {
        return TypeToken.of(Byte.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public TypeToken<Byte> primitiveType() {
        return TypeToken.of(Byte.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Byte> {
        private Visitor() {
            super(Byte.class, ByteAttributeConverter.class);
        }

        @Override
        public Byte convertNumber(String number) {
            return Byte.parseByte(number);
        }
    }
}

