/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticTableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class Attribute<T> {
    private final String attributeName;
    private final Function<T, AttributeValue> getAttributeMethod;
    private final BiConsumer<T, AttributeValue> updateItemMethod;
    private final StaticTableMetadata tableMetadata;
    private final AttributeValueType attributeValueType;

    private Attribute(String attributeName, Function<T, AttributeValue> getAttributeMethod, BiConsumer<T, AttributeValue> updateItemMethod, StaticTableMetadata tableMetadata, AttributeValueType attributeValueType) {
        this.attributeName = attributeName;
        this.getAttributeMethod = getAttributeMethod;
        this.updateItemMethod = updateItemMethod;
        this.tableMetadata = tableMetadata;
        this.attributeValueType = attributeValueType;
    }

    public static <T, R> AttributeSupplier<T> create(String attributeName, Function<T, R> getAttributeMethod, BiConsumer<T, R> updateItemMethod, AttributeType<R> attributeType) {
        Function<Object, AttributeValue> getAttributeValueWithTransform = item -> {
            Object value = getAttributeMethod.apply(item);
            return value == null ? AttributeValues.nullAttributeValue() : attributeType.objectToAttributeValue(value);
        };
        BiConsumer<Object, AttributeValue> updateItemWithTransform = (item, attributeValue) -> {
            if (EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                return;
            }
            Object value = attributeType.attributeValueToObject((AttributeValue)attributeValue);
            if (value != null) {
                updateItemMethod.accept(item, value);
            }
        };
        return new AttributeSupplier(attributeName, getAttributeValueWithTransform, updateItemWithTransform, attributeType.attributeValueType());
    }

    public <R> Attribute<R> transform(Function<R, T> transform, Consumer<R> createComponent) {
        return new Attribute<Object>(this.attributeName, item -> {
            Object otherItem = transform.apply(item);
            return otherItem == null ? AttributeValues.nullAttributeValue() : this.getAttributeMethod.apply(otherItem);
        }, (item, value) -> {
            if (createComponent != null) {
                createComponent.accept(item);
            }
            this.updateItemMethod.accept(transform.apply(item), (AttributeValue)value);
        }, this.tableMetadata, this.attributeValueType);
    }

    String attributeName() {
        return this.attributeName;
    }

    Function<T, AttributeValue> attributeGetterMethod() {
        return this.getAttributeMethod;
    }

    BiConsumer<T, AttributeValue> updateItemMethod() {
        return this.updateItemMethod;
    }

    StaticTableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    public static class AttributeSupplier<T>
    implements Supplier<Attribute<T>> {
        private final String attributeName;
        private final Function<T, AttributeValue> getAttributeValue;
        private final BiConsumer<T, AttributeValue> updateItem;
        private final StaticTableMetadata.Builder tableMetadataBuilder = StaticTableMetadata.builder();
        private final AttributeValueType attributeValueType;

        private AttributeSupplier(String attributeName, Function<T, AttributeValue> getAttributeValue, BiConsumer<T, AttributeValue> updateItem, AttributeValueType attributeValueType) {
            this.attributeName = attributeName;
            this.getAttributeValue = getAttributeValue;
            this.updateItem = updateItem;
            this.attributeValueType = attributeValueType;
        }

        @Override
        public Attribute<T> get() {
            return new Attribute(this.attributeName, this.getAttributeValue, this.updateItem, this.tableMetadataBuilder.build(), this.attributeValueType);
        }

        public AttributeSupplier<T> as(AttributeTag ... attributeTags) {
            Arrays.stream(attributeTags).forEach(attributeTag -> attributeTag.setTableMetadataForAttribute(this.attributeName, this.attributeValueType, this.tableMetadataBuilder));
            return this;
        }
    }
}

